/*
 * Decompiled with CFR 0.152.
 */
package lunatrius.schematica;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lunatrius.schematica.SchematicWorld;
import lunatrius.schematica.Schematica;
import lunatrius.schematica.gui.GuiSchematicControl;
import lunatrius.schematica.gui.GuiSchematicLoad;
import lunatrius.schematica.gui.GuiSchematicSave;
import lunatrius.schematica.renderer.RendererSchematicChunk;
import lunatrius.schematica.renderer.RendererTileEntity;
import lunatrius.schematica.util.MCLogger;
import lunatrius.schematica.util.Vector3f;
import lunatrius.schematica.util.Vector3i;
import net.minecraft.client.Minecraft;

public class Settings {
    private static final Settings instance = new Settings();
    public boolean enableAlpha = false;
    public float alpha = 1.0f;
    public boolean highlight = true;
    public boolean highlightAir = true;
    public float blockDelta = 0.005f;
    public arv[] keyBindings = new arv[]{new arv("key.schematic.load", 181), new arv("key.schematic.save", 55), new arv("key.schematic.control", 74)};
    public static final File schematicDirectory = new File(Minecraft.b(), "/schematics/");
    public static final File textureDirectory = new File(Minecraft.b(), "/resources/mod/schematica/");
    public static final MCLogger logger = MCLogger.getLogger(Schematica.class.getSimpleName());
    public static final bce renderItem = new bce();
    public static final ur defaultIcon = new ur(2, 1, 0);
    public Minecraft minecraft = Minecraft.x();
    public ys mcWorldCache = null;
    public SchematicWorld schematic = null;
    public Vector3f playerPosition = new Vector3f();
    public RendererSchematicChunk[][][] rendererSchematicChunk = null;
    public final List sortedRendererSchematicChunk = new ArrayList();
    public bbb renderBlocks = null;
    public RendererTileEntity rendererTileEntity = null;
    public Vector3i pointA = new Vector3i();
    public Vector3i pointB = new Vector3i();
    public Vector3i pointMin = new Vector3i();
    public Vector3i pointMax = new Vector3i();
    public int rotationRender = 0;
    public Vector3i offset = new Vector3i();
    public boolean isRenderingSchematic = false;
    public int renderingLayer = -1;
    public boolean isRenderingGuide = false;
    public int[] increments = new int[]{1, 5, 15, 50, 250};

    private Settings() {
    }

    public static Settings instance() {
        return instance;
    }

    public void keyboardEvent(arv keybinding) {
        if (this.minecraft.r == null) {
            for (int i = 0; i < this.keyBindings.length; ++i) {
                if (keybinding != this.keyBindings[i]) continue;
                this.keyboardEvent(i);
                break;
            }
        }
    }

    public void keyboardEvent(int key) {
        switch (key) {
            case 0: {
                this.minecraft.a((aul)new GuiSchematicLoad(this.minecraft.r));
                break;
            }
            case 1: {
                this.minecraft.a((aul)new GuiSchematicSave(this.minecraft.r));
                break;
            }
            case 2: {
                this.minecraft.a((aul)new GuiSchematicControl(this.minecraft.r));
            }
        }
    }

    public void createRendererSchematicChunk() {
        int width = (this.schematic.width() - 1) / 16 + 1;
        int height = (this.schematic.height() - 1) / 16 + 1;
        int length = (this.schematic.length() - 1) / 16 + 1;
        this.rendererSchematicChunk = new RendererSchematicChunk[width][height][length];
        while (this.sortedRendererSchematicChunk.size() > 0) {
            ((RendererSchematicChunk)this.sortedRendererSchematicChunk.remove(0)).delete();
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < length; ++z) {
                    RendererSchematicChunk rendererSchematicChunk = new RendererSchematicChunk(this.schematic, x, y, z);
                    this.rendererSchematicChunk[x][y][z] = rendererSchematicChunk;
                    this.sortedRendererSchematicChunk.add(rendererSchematicChunk);
                }
            }
        }
    }

    public boolean loadSchematic(String filename) {
        try {
            FileInputStream stream = new FileInputStream(filename);
            bq tagCompound = ca.a((InputStream)stream);
            if (tagCompound != null) {
                this.schematic = new SchematicWorld();
                this.schematic.readFromNBT(tagCompound);
                logger.info(String.format("Loaded %s [w:%d,h:%d,l:%d]", filename, this.schematic.width(), this.schematic.height(), this.schematic.length()));
                this.renderBlocks = new bbb((ym)this.schematic);
                this.rendererTileEntity = new RendererTileEntity(this.schematic);
                this.createRendererSchematicChunk();
                this.isRenderingSchematic = true;
            }
        }
        catch (Exception e) {
            logger.log(e);
            this.schematic = null;
            this.renderBlocks = null;
            this.rendererTileEntity = null;
            this.rendererSchematicChunk = null;
            this.isRenderingSchematic = false;
            return false;
        }
        return true;
    }

    public boolean saveSchematic(File directory, String filename, Vector3i from, Vector3i to) {
        try {
            bq tagCompound = new bq("Schematic");
            int minX = Math.min(from.x, to.x);
            int maxX = Math.max(from.x, to.x);
            int minY = Math.min(from.y, to.y);
            int maxY = Math.max(from.y, to.y);
            int minZ = Math.min(from.z, to.z);
            int maxZ = Math.max(from.z, to.z);
            short width = (short)(Math.abs(maxX - minX) + 1);
            short height = (short)(Math.abs(maxY - minY) + 1);
            short length = (short)(Math.abs(maxZ - minZ) + 1);
            int[][][] blocks = new int[width][height][length];
            int[][][] metadata = new int[width][height][length];
            ArrayList<any> tileEntities = new ArrayList<any>();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        blocks[x - minX][y - minY][z - minZ] = this.minecraft.e.a(x, y, z);
                        metadata[x - minX][y - minY][z - minZ] = this.minecraft.e.h(x, y, z);
                        if (this.minecraft.e.q(x, y, z) == null) continue;
                        bq te = new bq();
                        this.minecraft.e.q(x, y, z).b(te);
                        any tileEntity = any.c((bq)te);
                        tileEntity.l -= minX;
                        tileEntity.m -= minY;
                        tileEntity.n -= minZ;
                        tileEntities.add(tileEntity);
                    }
                }
            }
            String icon = Integer.toString(Settings.defaultIcon.l().c);
            try {
                String[] parts = filename.split(";");
                if (parts.length == 2) {
                    icon = parts[0];
                    filename = parts[1];
                }
            }
            catch (Exception e) {
                logger.log(e);
            }
            SchematicWorld schematicOut = new SchematicWorld(icon, blocks, metadata, tileEntities, width, height, length);
            schematicOut.writeToNBT(tagCompound);
            FileOutputStream stream = new FileOutputStream(new File(directory, filename));
            ca.a((bq)tagCompound, (OutputStream)stream);
        }
        catch (Exception e) {
            logger.log(e);
            return false;
        }
        return true;
    }

    public float getTranslationX() {
        return this.playerPosition.x - (float)this.offset.x;
    }

    public float getTranslationY() {
        return this.playerPosition.y - (float)this.offset.y;
    }

    public float getTranslationZ() {
        return this.playerPosition.z - (float)this.offset.z;
    }

    public void refreshSchematic() {
        for (RendererSchematicChunk renderer : this.sortedRendererSchematicChunk) {
            renderer.setDirty();
        }
    }

    public void updatePoints() {
        this.pointMin.x = Math.min(this.pointA.x, this.pointB.x);
        this.pointMin.y = Math.min(this.pointA.y, this.pointB.y);
        this.pointMin.z = Math.min(this.pointA.z, this.pointB.z);
        this.pointMax.x = Math.max(this.pointA.x, this.pointB.x);
        this.pointMax.y = Math.max(this.pointA.y, this.pointB.y);
        this.pointMax.z = Math.max(this.pointA.z, this.pointB.z);
    }

    public void moveHere(Vector3i point) {
        point.x = (int)Math.floor(this.playerPosition.x);
        point.y = (int)Math.floor(this.playerPosition.y - 1.0f);
        point.z = (int)Math.floor(this.playerPosition.z);
        switch (this.rotationRender) {
            case 0: {
                --point.x;
                ++point.z;
                break;
            }
            case 1: {
                --point.x;
                --point.z;
                break;
            }
            case 2: {
                ++point.x;
                --point.z;
                break;
            }
            case 3: {
                ++point.x;
                ++point.z;
            }
        }
    }

    public void moveHere() {
        this.offset.x = (int)Math.floor(this.playerPosition.x);
        this.offset.y = (int)Math.floor(this.playerPosition.y) - 1;
        this.offset.z = (int)Math.floor(this.playerPosition.z);
        if (this.schematic != null) {
            switch (this.rotationRender) {
                case 0: {
                    this.offset.x -= this.schematic.width();
                    ++this.offset.z;
                    break;
                }
                case 1: {
                    this.offset.x -= this.schematic.width();
                    this.offset.z -= this.schematic.length();
                    break;
                }
                case 2: {
                    ++this.offset.x;
                    this.offset.z -= this.schematic.length();
                    break;
                }
                case 3: {
                    ++this.offset.x;
                    ++this.offset.z;
                }
            }
            this.reloadChunkCache();
        }
    }

    public void toggleRendering() {
        this.isRenderingSchematic = !this.isRenderingSchematic && this.schematic != null;
    }

    public void reloadChunkCache() {
        if (this.schematic != null) {
            this.mcWorldCache = new ys((yc)this.minecraft.e, this.offset.x - 1, this.offset.y - 1, this.offset.z - 1, this.offset.x + this.schematic.width() + 1, this.offset.y + this.schematic.height() + 1, this.offset.z + this.schematic.length() + 1);
            this.refreshSchematic();
        }
    }

    public void flipWorld() {
        if (this.schematic != null) {
            this.schematic.flip();
            this.createRendererSchematicChunk();
        }
    }

    public void rotateWorld() {
        if (this.schematic != null) {
            this.schematic.rotate();
            this.createRendererSchematicChunk();
        }
    }
}

