/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Util;

public class LiquidFilter
implements ItemFilter {
    private static NamedTexture containerTexture = null;
    private LiquidStack liquid;
    private String liquidName;
    private List tooltip = new ArrayList();

    public LiquidFilter(LiquidStack liquid) {
        if (containerTexture == null) {
            containerTexture = Util.instance.getTexture("liquidFilterContainer");
        }
        this.setLiquid(liquid);
    }

    public void setLiquid(LiquidStack liquid) {
        String name = liquid.asItemStack().r();
        this.liquid = liquid;
        this.liquidName = name.toLowerCase();
        this.tooltip.clear();
        this.tooltip.add(name);
    }

    @Override
    public boolean matches(Object item) {
        if (item instanceof ur) {
            return this.liquid.isLiquidEqual((ur)item) || LiquidContainerRegistry.containsLiquid((ur)((ur)item), (LiquidStack)this.liquid);
        }
        if (item instanceof LiquidStack) {
            return this.liquid.isLiquidEqual((LiquidStack)item);
        }
        if (item instanceof String) {
            return this.liquidName.contains(((String)item).toLowerCase());
        }
        if (item instanceof List) {
            for (Object object : (List)item) {
                if (!this.matches(object)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void draw(Renderer renderer, int x, int y) {
        if (this.liquid != null) {
            bba renderEngine = FMLClientHandler.instance().getClient().o;
            if (this.liquid.itemID < amq.p.length && amq.p[this.liquid.itemID] != null) {
                amq block = amq.p[this.liquid.itemID];
                int index = block.cl;
                int texture = renderEngine.b(block.getTextureFile());
                GL11.glBindTexture((int)3553, (int)texture);
                LiquidFilter.rect(x + 3, y + 1, 10, 14, (index & 0xF) * 16 + 3, (index & 0xF0) + 1);
            } else if (up.e[this.liquid.itemID] != null) {
                up item = up.e[this.liquid.itemID];
                int index = item.b(this.liquid.itemMeta);
                int texture = renderEngine.b(item.getTextureFile());
                GL11.glBindTexture((int)3553, (int)texture);
                LiquidFilter.rect(x + 3, y + 1, 10, 14, (index & 0xF) * 16 + 3, (index & 0xF0) + 1);
            }
        }
        renderer.renderRect(x - 1, y - 1, 18, 18, containerTexture);
    }

    @Override
    public List getTooltip() {
        return this.tooltip;
    }

    private static void rect(int x, int y, int width, int height, int texX, int texY) {
        double u = (double)texX / 256.0;
        double v = (double)texY / 256.0;
        double u2 = (double)(texX + width) / 256.0;
        double v2 = (double)(texY + height) / 256.0;
        GL11.glEnable((int)3553);
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
        GL11.glBegin((int)7);
        GL11.glTexCoord2d((double)u, (double)v);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2d((double)u, (double)v2);
        GL11.glVertex2i((int)x, (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v2);
        GL11.glVertex2i((int)(x + width), (int)(y + height));
        GL11.glTexCoord2d((double)u2, (double)v);
        GL11.glVertex2i((int)(x + width), (int)y);
        GL11.glEnd();
    }
}

