/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.network;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketEffect;
import railcraft.common.util.network.PacketGuiReturn;
import railcraft.common.util.network.PacketGuiUpdate;
import railcraft.common.util.network.PacketPairRequest;
import railcraft.common.util.network.PacketPairUpdate;
import railcraft.common.util.network.PacketTileEntity;
import railcraft.common.util.network.PacketTileExtraData;
import railcraft.common.util.network.PacketTileRequest;
import railcraft.common.util.network.RailcraftPacket;

public class RailcraftPacketHandler
implements IPacketHandler {
    private static RailcraftPacket.PacketType[] packetTypes = RailcraftPacket.PacketType.values();

    public void onPacketData(ce manager, di packet, Player player) {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(packet.c));
        try {
            RailcraftPacket pkt = null;
            byte packetID = data.readByte();
            if (packetID < 0) {
                return;
            }
            RailcraftPacket.PacketType type = packetTypes[packetID];
            switch (type) {
                case TILE_ENTITY: {
                    pkt = new PacketTileEntity();
                    break;
                }
                case GUI_RETURN: {
                    pkt = new PacketGuiReturn();
                    break;
                }
                case TILE_EXTRA_DATA: {
                    pkt = new PacketTileExtraData();
                    break;
                }
                case TILE_REQUEST: {
                    pkt = new PacketTileRequest(player);
                    break;
                }
                case GUI_UPDATE: {
                    pkt = new PacketGuiUpdate();
                    break;
                }
                case EFFECT: {
                    pkt = new PacketEffect();
                    break;
                }
                case CONTROLLER_UPDATE: 
                case RECEIVER_UPDATE: {
                    pkt = new PacketPairUpdate(type);
                    break;
                }
                case CONTROLLER_REQUEST: 
                case RECEIVER_REQUEST: {
                    pkt = new PacketPairRequest(player, type);
                    break;
                }
                default: {
                    return;
                }
            }
            ((RailcraftPacket)pkt).readData(data);
        }
        catch (IOException e) {
            Game.log(Level.SEVERE, "Exception in PacketHandler.onPacketData {0}", e);
            e.printStackTrace();
        }
    }
}

