/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class Vec2D
extends Point2D.Double {
    public static final float DEGREES_45 = 0.7853982f;
    public static final float DEGREES_90 = 1.5707964f;
    public static final float DEGREES_135 = 2.3561945f;
    public static final float DEGREES_180 = (float)Math.PI;
    public static final float DEGREES_270 = 4.712389f;

    public Vec2D() {
    }

    public Vec2D(Point2D p) {
        super(p.getX(), p.getY());
    }

    public Vec2D(double x, double y) {
        super(x, y);
    }

    @Override
    public Vec2D clone() {
        return new Vec2D(this.x, this.y);
    }

    public static Vec2D fromPolar(double angle, float magnitude) {
        Vec2D v = new Vec2D();
        v.setFromPolar(angle, magnitude);
        return v;
    }

    public static Vec2D add(Point2D a, Point2D b) {
        return new Vec2D(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Vec2D subtract(Point2D a, Point2D b) {
        return new Vec2D(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setFromPolar(double angle, float magnitude) {
        float x = (float)Math.cos(angle) * magnitude;
        float y = (float)Math.sin(angle) * magnitude;
        this.setLocation(x, y);
    }

    public void zero() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public void normalize() {
        double mag = this.magnitude();
        if (mag != 0.0) {
            this.setLocation(this.x / mag, this.y / mag);
        }
    }

    public Vec2D unitVector() {
        Vec2D v = this.clone();
        v.normalize();
        return v;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void setMagnitude(float mag) {
        this.setFromPolar(this.angle(), mag);
    }

    public double magnitudeSq() {
        return this.x * this.x + this.y * this.y;
    }

    public void negate() {
        this.x = -this.x;
        this.y = -this.y;
    }

    public float angle() {
        return (float)Math.atan2(this.y, this.x);
    }

    public void rotate(double theta) {
        double nx2 = this.x * (double)((float)Math.cos(theta)) - this.y * (double)((float)Math.sin(theta));
        double ny = this.x * (double)((float)Math.sin(theta)) + this.y * (double)((float)Math.cos(theta));
        this.setLocation(nx2, ny);
    }

    public void rotate90() {
        double ox2 = this.x;
        this.x = -this.y;
        this.y = ox2;
    }

    public void rotate270() {
        double ox2 = this.x;
        this.x = this.y;
        this.y = -ox2;
    }

    public void subtract(Point2D p) {
        this.x -= p.getX();
        this.y -= p.getY();
    }

    public void subtract(int x, int y) {
        this.x -= (double)x;
        this.y -= (double)y;
    }

    public void subtract(double x, double y) {
        this.x -= (double)((int)x);
        this.y -= (double)((int)y);
    }

    public void add(Point2D p) {
        this.x += p.getX();
        this.y += p.getY();
    }

    public void add(int x, int y) {
        this.x += (double)x;
        this.y += (double)y;
    }

    public void add(double x, double y) {
        this.x += (double)((int)x);
        this.y += (double)((int)y);
    }

    public void transform(AffineTransform a) {
        this.setLocation(a.transform(this, null));
    }

    public Vec2D makeTransform(AffineTransform a) {
        return new Vec2D(a.transform(this, null));
    }

    public double dotProduct(Point2D v) {
        return this.x * v.getX() + this.y * v.getY();
    }

    public double angleBetween(Vec2D v) {
        double a = this.dotProduct(v);
        double magnitude = this.magnitude() * v.magnitude();
        if (magnitude == 0.0) {
            return 0.0;
        }
        if ((a /= magnitude) > 1.0) {
            a = 1.0;
        } else if (a < -1.0) {
            a = -1.0;
        }
        return Math.acos(a);
    }

    public double angleTo(Point2D a) {
        return Math.atan2(a.getY() - this.y, a.getX() - this.x);
    }

    public double angleFrom(Point2D a) {
        return Math.atan2(this.y - a.getY(), this.x - a.getX());
    }

    public void scale(float scale) {
        this.x *= (double)scale;
        this.y *= (double)scale;
    }

    public void addScale(float scale, Point2D v) {
        this.setLocation(this.x + v.getX() * (double)scale, this.y + v.getY() * (double)scale);
    }
}

