/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;

public class RevolvingList
implements Collection {
    private Deque list = new LinkedList();

    public void rotateLeft() {
        this.list.addFirst(this.list.removeLast());
    }

    public void rotateRight() {
        this.list.addLast(this.list.removeFirst());
    }

    public Object getCurrent() {
        return this.list.getFirst();
    }

    public void setCurrent(Object e) {
        if (!this.contains(e)) {
            return;
        }
        while (!this.getCurrent().equals(e)) {
            this.rotateRight();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.list.toArray(a);
    }

    public boolean add(Object e) {
        if (e == null) {
            return false;
        }
        return this.list.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.list.containsAll(c);
    }

    public boolean addAll(Collection c) {
        boolean changed = false;
        for (Object e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    public boolean removeAll(Collection c) {
        return this.list.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

