/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.util.misc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.OreDictionary;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidFilter;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.Game;

public abstract class MiscTools {
    private static Random rand = new Random();

    public static Random getRand() {
        return rand;
    }

    public static int getItemBurnTime(ur stack) {
        try {
            amq block;
            String name;
            if (stack == null) {
                return 0;
            }
            int itemID = stack.b().cj;
            if (stack.b() instanceof vq && amq.p[itemID] != null && (name = (block = amq.p[itemID]).a()) != null && name.contains("blockScaffold")) {
                return 0;
            }
            LiquidStack liquid = LiquidManager.getInstance().getLiquidInContainer(stack);
            if (LiquidFilter.LAVA.isLiquidEqual(liquid)) {
                return liquid.amount;
            }
            if (itemID == up.m.cj && stack.j() == 0 && !InvTools.isSynthetic(stack)) {
                return 3200;
            }
            if (itemID == up.bo.cj) {
                return 800;
            }
            name = stack.b().a();
            if (name != null && name.contains("itemScrap")) {
                return 0;
            }
            return anr.a((ur)stack);
        }
        catch (Exception ex) {
            Game.logError("Error in Fuel Handler! Is some mod creating items that are not compliant with standards?", ex);
            return 0;
        }
    }

    public static boolean isOreClass(ur stack, String tag) {
        ArrayList ores = OreDictionary.getOres((String)tag);
        for (ur ore : ores) {
            if (!InvTools.isItemEqual(ore, stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlayerConnected(String username) {
        return FMLCommonHandler.instance().getMinecraftServerInstance().ad().f(username) != null;
    }

    public static void registerMinecart(Object mod, Class type, String tag, int internalId) {
        EntityRegistry.registerModEntity((Class)type, (String)tag, (int)internalId, (Object)mod, (int)80, (int)3, (boolean)true);
    }

    public static void registerTrack(EnumTrack rail) {
        RailcraftBlocks.registerBlockTrack();
        if (RailcraftBlocks.getBlockTrack() != null && RailcraftConfig.isSubBlockEnabled(rail.getTag())) {
            if (rail.getTileClass() != null) {
                GameRegistry.registerTileEntity((Class)rail.getTileClass(), (String)rail.getTileTag());
            }
            ur stack = rail.registerRecipe();
            RailcraftLanguage.getInstance().registerItemName(stack, rail.getTag());
            ItemRegistry.registerItem(rail.getTag(), stack);
        }
    }

    public static String cleanTag(String tag) {
        return tag.replace("rc.", "");
    }

    public static aoh collisionRayTrace(aoj vec3d, aoj vec3d1, int i, int j, int k) {
        vec3d = vec3d.c((double)(-i), (double)(-j), (double)(-k));
        vec3d1 = vec3d1.c((double)(-i), (double)(-j), (double)(-k));
        aoj vec3d2 = vec3d.b(vec3d1, 0.0);
        aoj vec3d3 = vec3d.b(vec3d1, 1.0);
        aoj vec3d4 = vec3d.c(vec3d1, 0.0);
        aoj vec3d5 = vec3d.c(vec3d1, 1.0);
        aoj vec3d6 = vec3d.d(vec3d1, 0.0);
        aoj vec3d7 = vec3d.d(vec3d1, 1.0);
        if (!MiscTools.isVecInsideYZBounds(vec3d2)) {
            vec3d2 = null;
        }
        if (!MiscTools.isVecInsideYZBounds(vec3d3)) {
            vec3d3 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d4)) {
            vec3d4 = null;
        }
        if (!MiscTools.isVecInsideXZBounds(vec3d5)) {
            vec3d5 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d6)) {
            vec3d6 = null;
        }
        if (!MiscTools.isVecInsideXYBounds(vec3d7)) {
            vec3d7 = null;
        }
        aoj vec3d8 = null;
        if (vec3d2 != null && (vec3d8 == null || vec3d.d(vec3d2) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d2;
        }
        if (vec3d3 != null && (vec3d8 == null || vec3d.d(vec3d3) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d3;
        }
        if (vec3d4 != null && (vec3d8 == null || vec3d.d(vec3d4) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d4;
        }
        if (vec3d5 != null && (vec3d8 == null || vec3d.d(vec3d5) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d5;
        }
        if (vec3d6 != null && (vec3d8 == null || vec3d.d(vec3d6) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d6;
        }
        if (vec3d7 != null && (vec3d8 == null || vec3d.d(vec3d7) < vec3d.d(vec3d8))) {
            vec3d8 = vec3d7;
        }
        if (vec3d8 == null) {
            return null;
        }
        int byte0 = -1;
        if (vec3d8 == vec3d2) {
            byte0 = 4;
        }
        if (vec3d8 == vec3d3) {
            byte0 = 5;
        }
        if (vec3d8 == vec3d4) {
            byte0 = 0;
        }
        if (vec3d8 == vec3d5) {
            byte0 = 1;
        }
        if (vec3d8 == vec3d6) {
            byte0 = 2;
        }
        if (vec3d8 == vec3d7) {
            byte0 = 3;
        }
        return new aoh(i, j, k, byte0, vec3d8.c((double)i, (double)j, (double)k));
    }

    private static boolean isVecInsideYZBounds(aoj vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.d >= 0.0 && vec3d.d <= 1.0 && vec3d.e >= 0.0 && vec3d.e <= 1.0;
    }

    private static boolean isVecInsideXZBounds(aoj vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.c >= 0.0 && vec3d.c <= 1.0 && vec3d.e >= 0.0 && vec3d.e <= 1.0;
    }

    private static boolean isVecInsideXYBounds(aoj vec3d) {
        if (vec3d == null) {
            return false;
        }
        return vec3d.c >= 0.0 && vec3d.c <= 1.0 && vec3d.d >= 0.0 && vec3d.d <= 1.0;
    }

    public static ForgeDirection getCurrentMousedOverSide(qx player) {
        double distance = player.cd.d ? 5.0 : 4.5;
        aoj posVec = aoj.a((double)player.t, (double)player.u, (double)player.v);
        aoj lookVec = player.i(1.0f);
        posVec.d += (double)player.e();
        lookVec = posVec.c(lookVec.c * distance, lookVec.d * distance, lookVec.e * distance);
        aoh mouseOver = player.p.a(posVec, lookVec);
        if (mouseOver != null) {
            return ForgeDirection.getOrientation((int)mouseOver.e);
        }
        return ForgeDirection.UNKNOWN;
    }

    public static ForgeDirection getSideClosestToPlayer(yc world, int i, int j, int k, md entityplayer) {
        if (ke.e((float)((float)entityplayer.t - (float)i)) < 2.0f && ke.e((float)((float)entityplayer.v - (float)k)) < 2.0f) {
            double d = entityplayer.u + 1.82 - (double)entityplayer.M;
            if (d - (double)j > 2.0) {
                return ForgeDirection.UP;
            }
            if ((double)j - d > 0.0) {
                return ForgeDirection.DOWN;
            }
        }
        int dir = ke.c((double)((double)(entityplayer.z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
        }
        return dir != 3 ? ForgeDirection.DOWN : ForgeDirection.WEST;
    }

    public static ForgeDirection getHorizontalSideClosestToPlayer(yc world, int i, int j, int k, md player) {
        ForgeDirection facing = ForgeDirection.NORTH;
        int dir = ke.c((double)((double)(player.z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (dir) {
            case 0: {
                return ForgeDirection.NORTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection getOppositeSide(int side) {
        int s = side;
        s = s % 2 == 0 ? s + 1 : s - 1;
        return ForgeDirection.getOrientation((int)s);
    }

    public static int getYOnSide(int y, ForgeDirection side) {
        switch (side) {
            case UP: {
                return y + 1;
            }
            case DOWN: {
                return y - 1;
            }
        }
        return y;
    }

    public static int getXOnSide(int x, ForgeDirection side) {
        switch (side) {
            case EAST: {
                return x + 1;
            }
            case WEST: {
                return x - 1;
            }
        }
        return x;
    }

    public static int getZOnSide(int z, ForgeDirection side) {
        switch (side) {
            case NORTH: {
                return z - 1;
            }
            case SOUTH: {
                return z + 1;
            }
        }
        return z;
    }

    public static boolean blockExistsOnSide(yc world, int x, int y, int z, ForgeDirection side) {
        return world.f(MiscTools.getXOnSide(x, side), MiscTools.getYOnSide(y, side), MiscTools.getZOnSide(z, side));
    }

    public static int getBlockMetadataOnSide(yc world, int i, int j, int k, ForgeDirection side) {
        return world.h(MiscTools.getXOnSide(i, side), MiscTools.getYOnSide(j, side), MiscTools.getZOnSide(k, side));
    }

    public static int getBlockIdOnSide(ym world, int x, int y, int z, ForgeDirection side) {
        return world.a(MiscTools.getXOnSide(x, side), MiscTools.getYOnSide(y, side), MiscTools.getZOnSide(z, side));
    }

    public static any getBlockTileEntityOnSide(yc world, int i, int j, int k, ForgeDirection side) {
        return world.q(MiscTools.getXOnSide(i, side), MiscTools.getYOnSide(j, side), MiscTools.getZOnSide(k, side));
    }

    public static void notifyBlocksOfNeighborChangeOnSide(yc world, int i, int j, int k, int blockID, ForgeDirection side) {
        world.h(MiscTools.getXOnSide(i, side), MiscTools.getYOnSide(j, side), MiscTools.getZOnSide(k, side), blockID);
    }
}

