/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.items;

import com.google.common.collect.MapMaker;
import java.util.Map;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import railcraft.common.api.carts.ILinkableCart;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.carts.EntityTunnelBore;
import railcraft.common.carts.IDirectionalCart;
import railcraft.common.carts.LinkageManager;
import railcraft.common.modules.ModuleManager;
import railcraft.common.util.misc.Game;

public class CrowbarHandler {
    public static final float SMACK_VELOCITY = 0.07f;
    private static Map linkMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static CrowbarHandler instance;

    public static CrowbarHandler getInstance() {
        if (instance == null) {
            instance = new CrowbarHandler();
        }
        return instance;
    }

    @ForgeSubscribe
    public void onEntityInteract(EntityInteractEvent event) {
        qx thePlayer = event.entityPlayer;
        lq entity = event.target;
        thePlayer.bH();
        if (Game.isNotHost(thePlayer.p)) {
            return;
        }
        if (!ModuleManager.isModuleLoaded(ModuleManager.Module.TRAIN)) {
            return;
        }
        boolean used = false;
        ur stack = thePlayer.bS();
        if (stack != null && stack.b() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)stack.b();
            if (entity instanceof py) {
                py cart = (py)entity;
                if (crowbar.canLink(thePlayer, stack, cart)) {
                    boolean linkable = cart instanceof ILinkableCart;
                    if (!linkable || linkable && ((ILinkableCart)cart).isLinkable()) {
                        if (linkMap.containsKey(thePlayer)) {
                            py last;
                            LinkageManager lm = LinkageManager.getInstance(thePlayer.p);
                            if (lm.areLinked(cart, last = (py)linkMap.remove(thePlayer))) {
                                lm.breakLink(cart, last);
                                used = true;
                                thePlayer.b("Link Broken");
                            } else {
                                used = lm.createLink((py)entity, last);
                                if (used) {
                                    thePlayer.b("Link Created");
                                }
                            }
                            if (!used) {
                                thePlayer.b("Link Failed");
                            }
                        } else {
                            linkMap.put(thePlayer, (py)entity);
                            thePlayer.b("Link Started");
                        }
                    }
                    if (used) {
                        crowbar.onLink(thePlayer, stack, cart);
                    }
                } else if (crowbar.canBoost(thePlayer, stack, cart)) {
                    thePlayer.j(1.0f);
                    if (!(cart instanceof EntityTunnelBore)) {
                        if (cart instanceof IDirectionalCart) {
                            ((IDirectionalCart)cart).reverse();
                        } else {
                            cart.w = cart.t < thePlayer.t ? (cart.w -= (double)0.07f) : (cart.w += (double)0.07f);
                            cart.y = cart.v < thePlayer.v ? (cart.y -= (double)0.07f) : (cart.y += (double)0.07f);
                        }
                    }
                    crowbar.onBoost(thePlayer, stack, cart);
                }
            }
        }
        event.setCanceled(used);
    }
}

