/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.ICartRenderInterface;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.MiscTools;

public class EntityCartFurnace
extends CartBase
implements ICartRenderInterface {
    private static final double DRAG_FACTOR = 0.99;
    private static final double PUSH_FACTOR = 0.1;

    public EntityCartFurnace(yc world) {
        super(world);
    }

    public EntityCartFurnace(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.q = d;
        this.r = d1;
        this.s = d2;
        this.e = 0;
        this.b = 0.0;
        this.c = 0.0;
        this.a = 2;
    }

    public boolean isActive() {
        return this.e > 0;
    }

    protected void applyDragAndPushForces() {
        this.w *= this.getDrag();
        this.x *= 0.0;
        this.y *= this.getDrag();
        double d27 = ke.a((double)(this.b * this.b + this.c * this.c));
        if (d27 > 0.01) {
            this.b /= d27;
            this.c /= d27;
            double d29 = 0.4;
            this.w += this.b * d29;
            this.y += this.c * d29;
        }
    }

    protected void updatePushForces() {
        double d30 = ke.a((double)(this.b * this.b + this.c * this.c));
        if (d30 > 0.01 && this.w * this.w + this.y * this.y > 0.001) {
            this.b /= d30;
            this.c /= d30;
            if (this.b * this.w + this.c * this.y < 0.0) {
                this.b = 0.0;
                this.c = 0.0;
            } else {
                this.b = this.w;
                this.c = this.y;
            }
        }
    }

    public void j_() {
        if (this.h() && this.aa.nextInt(4) == 0) {
            this.p.a("largesmoke", this.t, this.u + 0.8, this.v, 0.0, 0.0, 0.0);
        }
        super.j_();
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ur(up.az));
            items.add(new ur(amq.aE));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public ur getCartItem() {
        return new ur(up.aO);
    }

    public double getDrag() {
        return 0.99;
    }

    @Override
    public float getCartMaxSpeed() {
        return 0.39f;
    }

    public boolean isPoweredCart() {
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int k_() {
        return 0;
    }

    public String b() {
        return "Steamcart";
    }

    @Override
    public boolean doInteract(qx entityplayer) {
        int burnTime;
        ur stack = entityplayer.bJ.g();
        if (stack != null && (burnTime = MiscTools.getItemBurnTime(stack)) > 0) {
            entityplayer.bJ.a(entityplayer.bJ.c, InvTools.depleteItem(stack));
            this.e += burnTime;
            this.b = this.t - entityplayer.t;
            this.c = this.v - entityplayer.v;
        }
        return true;
    }

    @Override
    public amq getBlock() {
        return amq.aE;
    }

    @Override
    public int getBlockMetadata() {
        return 0;
    }
}

