/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.ICartRenderInterface;
import railcraft.common.api.carts.IEnergyTransfer;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.misc.APIErrorHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.IEnergyDevice;
import railcraft.common.util.misc.MiscTools;

public class EntityCartEnergy
extends CartBase
implements IEnergyDevice,
ICartRenderInterface,
IEnergyTransfer,
IEntityAdditionalSpawnData {
    private static final int ENERGY_DATA_ID = 20;
    private static final int[] CAPACITY = new int[]{40000, 600000, 10000000};
    private static final int[] TRANSFER_RATE = new int[]{128, 512, 2048};
    private int update;

    public EntityCartEnergy(yc world) {
        super(world);
    }

    public EntityCartEnergy(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
    }

    protected void a() {
        super.a();
        this.ag.a(20, (Object)new Integer(0));
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        ur stack = this.getIC2Item();
        if (RailcraftConfig.doCartsBreakOnDrop() && stack != null) {
            items.add(new ur(up.az));
            items.add(stack);
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    public void j_() {
        ur stack;
        ++this.update;
        super.j_();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (this.getEnergy() > this.getCapacity()) {
            this.setEnergy(this.getCapacity());
        }
        if ((stack = this.a(0)) != null && stack.b() instanceof IElectricItem && this.getEnergy() > 0) {
            this.setEnergy(this.getEnergy() - ElectricItem.charge(stack, this.getEnergy(), this.getTier(), false, false));
        }
        if ((stack = this.a(1)) != null && stack.b() instanceof IElectricItem && ((IElectricItem)stack.b()).canProvideEnergy() && this.getEnergy() < this.getCapacity()) {
            this.setEnergy(this.getEnergy() + ElectricItem.discharge(stack, this.getCapacity() - this.getEnergy(), this.getTier(), false, false));
        }
    }

    @Override
    public int getTier() {
        return this.a + 1;
    }

    protected double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public boolean doInteract(qx player) {
        if (Game.isHost(this.getWorld())) {
            GuiHandler.openGui(EnumGui.CART_ENERGY, player, this.p, (lq)this);
        }
        return true;
    }

    public boolean isStorageCart() {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int k_() {
        return 2;
    }

    public String b() {
        switch (this.a) {
            case 1: {
                return "MFE Cart";
            }
            case 2: {
                return "MFSU Cart";
            }
        }
        return "BatBox Cart";
    }

    protected void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.setEnergy(nbttagcompound.e("energy"));
        this.update = MiscTools.getRand().nextInt();
    }

    protected void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("energy", this.getEnergy());
    }

    @Override
    public int injectEnergy(Object source, int amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        int capacity;
        int energy;
        if (tier < this.getTier()) {
            return amount;
        }
        int extra = 0;
        if (!ignoreTransferLimit) {
            extra = Math.max(amount - this.getTransferLimit(), 0);
            amount = Math.min(amount, this.getTransferLimit());
        }
        if ((energy = this.getEnergy() + amount) > (capacity = this.getCapacity())) {
            extra += energy - capacity;
            energy = capacity;
        }
        if (!simulate) {
            this.setEnergy(energy);
        }
        if (!passAlong) {
            return extra;
        }
        try {
            ILinkageManager lm = CartTools.getLinkageManager(this.p);
            py linkedCart = lm.getLinkedCartA(this);
            if (extra > 0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
            linkedCart = lm.getLinkedCartB(this);
            if (extra > 0 && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
                extra = ((IEnergyTransfer)linkedCart).injectEnergy(this, extra, tier, ignoreTransferLimit, simulate, true);
            }
        }
        catch (Throwable t) {
            APIErrorHandler.versionMismatch(IEnergyTransfer.class);
        }
        return extra;
    }

    @Override
    public int extractEnergy(Object source, int amount, int tier, boolean ignoreTransferLimit, boolean simulate, boolean passAlong) {
        if (tier < this.getTier()) {
            return 0;
        }
        if (!ignoreTransferLimit) {
            amount = Math.min(amount, this.getTransferLimit());
        }
        int provide = 0;
        int energy = this.getEnergy();
        if ((energy -= (provide = Math.min(amount, energy))) < 0) {
            energy = 0;
        }
        if (!simulate) {
            this.setEnergy(energy);
        }
        if (!passAlong) {
            return provide;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        linkedCart = lm.getLinkedCartB(this);
        if (provide < amount && linkedCart != source && linkedCart instanceof IEnergyTransfer) {
            provide += ((IEnergyTransfer)linkedCart).extractEnergy(this, amount - provide, tier, ignoreTransferLimit, simulate, true);
        }
        return provide;
    }

    public ur getIC2Item() {
        switch (this.a) {
            case 1: {
                return IC2Plugin.getItem("mfeUnit");
            }
            case 2: {
                return IC2Plugin.getItem("mfsUnit");
            }
        }
        return IC2Plugin.getItem("batBox");
    }

    @Override
    public amq getBlock() {
        ur stack = this.getIC2Item();
        if (stack != null) {
            return amq.p[stack.c];
        }
        return null;
    }

    @Override
    public int getBlockMetadata() {
        ur stack = this.getIC2Item();
        if (stack != null) {
            return stack.j();
        }
        return 0;
    }

    @Override
    public int getCapacity() {
        return CAPACITY[this.a];
    }

    @Override
    public int getTransferLimit() {
        return TRANSFER_RATE[this.a];
    }

    @Override
    public int getEnergyBarScaled(int scale) {
        return this.getEnergy() * scale / this.getCapacity();
    }

    @Override
    public int getEnergy() {
        return this.ag.c(20);
    }

    protected void setEnergy(int energy) {
        this.ag.b(20, (Object)energy);
    }

    @Override
    public boolean canExtractEnergy() {
        return true;
    }

    @Override
    public boolean canInjectEnergy() {
        return true;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeByte((int)((byte)this.a));
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.a = data.readByte();
    }
}

