/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import net.minecraftforge.common.ForgeChunkManager;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.carts.EntityCartAnchor;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCart;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.MiscTools;

public class EntityCartAnchorPersonal
extends EntityCartAnchor {
    private static final int MINUTES_BEFORE_DISABLE = 5;
    private long ticksSincePlayerLogged;

    public EntityCartAnchorPersonal(yc world) {
        super(world);
    }

    public EntityCartAnchorPersonal(yc world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public void j_() {
        if (this.ticket != null) {
            this.ticksSincePlayerLogged = MiscTools.isPlayerConnected(CartTools.getCartOwner(this)) ? 0L : ++this.ticksSincePlayerLogged;
            if (this.ticksSincePlayerLogged > 6000L) {
                this.releaseTicket();
            }
        }
        super.j_();
    }

    @Override
    public boolean doesCartMatchFilter(ur stack, py cart) {
        return ItemCart.getCartType(stack) == EnumCart.ANCHOR_PERSONAL;
    }

    @Override
    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestPlayerTicket((Object)Railcraft.getMod(), (String)CartTools.getCartOwner(this), (yc)this.p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    @Override
    protected int getRefuelTime() {
        return RailcraftConfig.anchorRefuelPersonal();
    }

    @Override
    protected boolean meetsTicketRequirements() {
        return MiscTools.isPlayerConnected(CartTools.getCartOwner(this)) && super.meetsTicketRequirements();
    }

    @Override
    public int getBlockMetadata() {
        return EnumMachineAlpha.PERSONAL_ANCHOR.ordinal();
    }

    @Override
    public String b() {
        return RailcraftLanguage.translate(EnumCart.ANCHOR_PERSONAL.getTag());
    }

    @Override
    public int getBlockTextureOnSide(int side) {
        if (side < 2 && !this.e(6)) {
            return EnumMachineAlpha.PERSONAL_ANCHOR.getTexture(6);
        }
        return EnumMachineAlpha.PERSONAL_ANCHOR.getTexture(side);
    }
}

