/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks.speedcontroller;

import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.blocks.tracks.TrackSpeed;
import railcraft.common.blocks.tracks.speedcontroller.SpeedController;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.util.misc.MiscTools;

public class SpeedControllerHighSpeed
extends SpeedController {
    private static final int LOOK_AHEAD_DIST = 2;
    private static float SPEED_SLOPE = 0.45f;
    private static SpeedController instance;

    public static SpeedController getInstance() {
        if (instance == null) {
            instance = new SpeedControllerHighSpeed();
        }
        return instance;
    }

    @Override
    public float getMaxSpeed(ITrackInstance track, py cart) {
        Float speed = null;
        if (track instanceof TrackSpeed) {
            speed = ((TrackSpeed)track).maxSpeed;
        }
        if (speed == null) {
            speed = Float.valueOf(SpeedControllerHighSpeed.speedForCurrentTrack(track));
        }
        if (track instanceof TrackSpeed) {
            ((TrackSpeed)track).maxSpeed = speed;
        }
        return speed.floatValue();
    }

    public static float speedForCurrentTrack(ITrackInstance track) {
        int meta;
        int z;
        int y;
        int x;
        yc world = track.getWorld();
        int id = world.a(x = track.getX(), y = track.getY(), z = track.getZ());
        if (alr.e((int)id) && (meta = ((alr)amq.p[id]).getBasicRailMetadata((ym)world, null, x, y, z)) > 1 && meta < 6) {
            return SPEED_SLOPE;
        }
        return SpeedControllerHighSpeed.speedForNextTrack(world, x, y, z, 0);
    }

    private static float speedForNextTrack(yc world, int x, int y, int z, int dist) {
        float maxSpeed = RailcraftConfig.getMaxHighSpeed();
        if (dist < 2) {
            for (int side = 2; side < 6; ++side) {
                int zz;
                int yy2;
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                int xx2 = MiscTools.getXOnSide(x, dir);
                int id = world.a(xx2, yy2 = y, zz = MiscTools.getZOnSide(z, dir));
                if (!alr.e((int)id)) {
                    id = world.a(xx2, yy2 + 1, zz);
                    if (alr.e((int)id)) {
                        ++yy2;
                    } else {
                        id = world.a(xx2, yy2 - 1, zz);
                        if (alr.e((int)id)) {
                            --yy2;
                        }
                    }
                }
                if (!alr.e((int)id)) continue;
                int meta = ((alr)amq.p[id]).getBasicRailMetadata((ym)world, null, xx2, yy2, zz);
                if (meta > 1 && meta < 6) {
                    return SPEED_SLOPE;
                }
                maxSpeed = SpeedControllerHighSpeed.speedForNextTrack(world, xx2, yy2, zz, dist + 1);
                if (maxSpeed != SPEED_SLOPE) continue;
                return SPEED_SLOPE;
            }
        }
        return maxSpeed;
    }
}

