/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackSpeed;
import railcraft.common.carts.EntityLocomotive;

public class TrackSpeedTransition
extends TrackSpeed
implements ITrackPowered,
ITrackReversable {
    private boolean powered = false;
    private boolean reversed = false;
    private static final double BOOST_AMOUNT = 0.04;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED_TRANSITION;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            if (this.isReversed()) {
                return this.getTrackType().getTextureIndex() + 3;
            }
            return this.getTrackType().getTextureIndex() + 1;
        }
        if (this.isReversed()) {
            return this.getTrackType().getTextureIndex() + 2;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public int getPowerPropagation() {
        return 16;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public void onMinecartPass(py cart) {
        TrackSpeedTransition.testCartSpeedForBooster(this, cart);
        boolean highSpeed = cart.getEntityData().n("HighSpeed");
        if (this.powered) {
            double speed = Math.sqrt(cart.w * cart.w + cart.y * cart.y);
            if (speed > 0.01) {
                int meta = this.tileEntity.p();
                if (meta == 0 || meta == 4 || meta == 5) {
                    if (this.reversed ^ cart.y < 0.0) {
                        this.boostCartSpeed(cart, speed);
                    } else {
                        this.slowOrNormalCartSpeed(cart, highSpeed);
                    }
                } else if (meta == 1 || meta == 2 || meta == 3) {
                    if (!this.reversed ^ cart.w < 0.0) {
                        this.boostCartSpeed(cart, speed);
                    } else {
                        this.slowOrNormalCartSpeed(cart, highSpeed);
                    }
                }
            }
        } else if (highSpeed) {
            int meta = this.tileEntity.p();
            if (meta == 0 || meta == 4 || meta == 5) {
                if (this.reversed ^ cart.y > 0.0) {
                    this.slowCartSpeed(cart);
                }
            } else if ((meta == 1 || meta == 2 || meta == 3) && !this.reversed ^ cart.w > 0.0) {
                this.slowCartSpeed(cart);
            }
            cart.x = 0.0;
        } else {
            this.normalCartSpeed(cart);
        }
    }

    private void boostCartSpeed(py cart, double currentSpeed) {
        cart.w += cart.w / currentSpeed * 0.04;
        cart.y += cart.y / currentSpeed * 0.04;
    }

    private void slowCartSpeed(py cart) {
        if (cart instanceof EntityLocomotive) {
            ((EntityLocomotive)cart).forceIdle(20);
        }
        cart.w *= 0.65;
        cart.y *= 0.65;
    }

    private void slowOrNormalCartSpeed(py cart, boolean highSpeed) {
        if (highSpeed) {
            this.slowCartSpeed(cart);
        } else {
            this.normalCartSpeed(cart);
        }
    }

    private void normalCartSpeed(py cart) {
        if (Math.abs(cart.w) > 0.01) {
            cart.w = Math.copySign((double)0.3f, cart.w);
        }
        if (Math.abs(cart.y) > 0.01) {
            cart.y = Math.copySign((double)0.3f, cart.y);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
        nbttagcompound.a("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
        this.reversed = nbttagcompound.n("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean r) {
        this.reversed = r;
    }
}

