/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackSpeed;
import railcraft.common.carts.EntityLocomotive;

public class TrackSpeedBoost
extends TrackSpeed
implements ITrackPowered {
    private boolean powered = false;
    private static final double BOOST_AMOUNT = 0.06;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED_BOOST;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            return this.getTrackType().getTextureIndex() + 1;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public int getPowerPropagation() {
        return 16;
    }

    @Override
    public void onMinecartPass(py cart) {
        TrackSpeedBoost.testCartSpeedForBooster(this, cart);
        if (this.powered) {
            double speed = Math.sqrt(cart.w * cart.w + cart.y * cart.y);
            if (speed > 0.01) {
                cart.w += cart.w / speed * 0.06;
                cart.y += cart.y / speed * 0.06;
            }
        } else {
            boolean highSpeed = cart.getEntityData().n("HighSpeed");
            if (highSpeed) {
                if (cart instanceof EntityLocomotive) {
                    ((EntityLocomotive)cart).forceIdle(20);
                }
                cart.w *= 0.65;
                cart.x = 0.0;
                cart.y *= 0.65;
            } else {
                if (Math.abs(cart.w) > 0.0) {
                    cart.w = Math.copySign((double)0.38f, cart.w);
                }
                if (Math.abs(cart.y) > 0.0) {
                    cart.y = Math.copySign((double)0.38f, cart.y);
                }
            }
        }
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

