/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackReinforced;

public class TrackReinforcedBooster
extends TrackReinforced
implements ITrackPowered {
    private static final int POWER_PROPAGATION = 8;
    private static final double BOOST_FACTOR = 0.065;
    private static final double SLOW_FACTOR = 0.5;
    private static final double START_BOOST = 0.02;
    private static final double STALL_THRESHOLD = 0.03;
    private static final double BOOST_THRESHOLD = 0.01;
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.REINFORCED_BOOSTER;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            return this.getTrackType().getTextureIndex() + 1;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public void onMinecartPass(py cart) {
        int meta = this.tileEntity.p();
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k = this.tileEntity.n;
        int dirMeta = meta & 7;
        double speed = Math.sqrt(cart.w * cart.w + cart.y * cart.y);
        if (this.powered) {
            if (speed > 0.01) {
                cart.w += cart.w / speed * 0.065;
                cart.y += cart.y / speed * 0.065;
            } else if (dirMeta == 1) {
                if (this.getWorld().isBlockSolidOnSide(i - 1, j, k, ForgeDirection.EAST)) {
                    cart.w = 0.02;
                } else if (this.getWorld().isBlockSolidOnSide(i + 1, j, k, ForgeDirection.WEST)) {
                    cart.w = -0.02;
                }
            } else if (dirMeta == 0) {
                if (this.getWorld().isBlockSolidOnSide(i, j, k - 1, ForgeDirection.SOUTH)) {
                    cart.y = 0.02;
                } else if (this.getWorld().isBlockSolidOnSide(i, j, k + 1, ForgeDirection.NORTH)) {
                    cart.y = -0.02;
                }
            }
        } else if (speed < 0.03) {
            cart.w = 0.0;
            cart.x = 0.0;
            cart.y = 0.0;
        } else {
            cart.w *= 0.5;
            cart.x = 0.0;
            cart.y *= 0.5;
        }
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

