/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackReinforced;
import railcraft.common.blocks.tracks.speedcontroller.SpeedControllerReinforced;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.SafeNBTWrapper;
import railcraft.common.util.network.IGuiReturnHandler;

public class TrackLauncher
extends TrackReinforced
implements ITrackPowered,
IGuiReturnHandler {
    private boolean powered = false;
    private byte launchForce = (byte)5;
    public static final int MIN_LAUNCH_FORCE = 5;
    private static final float LAUNCH_THRESHOLD = 0.01f;

    public TrackLauncher() {
        this.speedController = SpeedControllerReinforced.getInstance();
    }

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LAUNCHER;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public int getTextureIndex() {
        if (!this.isPowered()) {
            return this.getTrackType().getTextureIndex() + 1;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public boolean blockActivated(qx player) {
        IToolCrowbar crowbar;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            GuiHandler.openGui(EnumGui.TRACK_LAUNCHER, player, this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(py cart) {
        if (this.isPowered()) {
            if (Math.abs(cart.w) > (double)0.01f) {
                cart.w = Math.copySign((double)0.6f, cart.w);
            }
            if (Math.abs(cart.y) > (double)0.01f) {
                cart.y = Math.copySign((double)0.6f, cart.y);
            }
            cart.setMaxSpeedAirLateral(0.6f);
            cart.setMaxSpeedAirVertical(0.5f);
            cart.setDragAir(0.99999);
            cart.x = (double)this.getLaunchForce() * 0.1;
            cart.getEntityData().a("Launched", 1);
            cart.setCanUseRail(false);
            cart.d(cart.w, 1.5, cart.y);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("powered", this.powered);
        data.a("force", this.getLaunchForce());
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.powered = data.n("powered");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.setLaunchForce(safe.getByte("force"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.launchForce);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.launchForce = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.launchForce);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.launchForce = data.readByte();
    }

    public byte getLaunchForce() {
        return this.launchForce;
    }

    public void setLaunchForce(int force) {
        force = Math.max(force, 5);
        force = Math.min(force, RailcraftConfig.getLaunchRailMaxForce());
        this.launchForce = (byte)force;
    }
}

