/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.tracks.ITrackLockdown;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackLockingBase;
import railcraft.common.util.misc.Game;

public class TrackBoarding
extends TrackLockingBase
implements ITrackPowered,
ITrackReversable,
ITrackLockdown {
    protected boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BOARDING;
    }

    @Override
    public int getTextureIndex() {
        if (this.isPowered() || this.delay > 0) {
            if (this.isReversed()) {
                return this.getTrackType().getTextureIndex() + 2;
            }
            return this.getTrackType().getTextureIndex();
        }
        if (this.isReversed()) {
            return this.getTrackType().getTextureIndex() + 3;
        }
        return this.getTrackType().getTextureIndex() + 1;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().L) {
            this.setCurrentCart(null);
        }
        if (Game.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    public void onMinecartPass(py cart) {
        this.checkCart(cart);
        int meta = this.tileEntity.p();
        if (this.isPowered() || this.delay > 0) {
            this.releaseCart(cart);
            double speed = CartTools.getCartSpeedUncapped(cart);
            double boostX = START_BOOST;
            double boostZ = START_BOOST;
            if (speed > 0.005) {
                boostX = Math.abs(cart.w) / speed * BOOST_FACTOR;
                boostZ = Math.abs(cart.y) / speed * BOOST_FACTOR;
            }
            if (meta == 0 || meta == 4 || meta == 5) {
                cart.y = this.isReversed() ? (cart.y += boostZ) : (cart.y -= boostZ);
            } else if (meta == 1 || meta == 2 || meta == 3) {
                cart.w = this.isReversed() ? (cart.w -= boostX) : (cart.w += boostX);
            }
        } else {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.w = 0.0;
                cart.y = 0.0;
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.v = (double)this.tileEntity.n + 0.5;
                } else {
                    cart.t = (double)this.tileEntity.l + 0.5;
                }
            }
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(bq data) {
        super.writeToNBT(data);
        data.a("direction", this.reversed);
    }

    @Override
    public void readFromNBT(bq data) {
        super.readFromNBT(data);
        this.reversed = data.n("direction");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

