/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.ItemSignalTuner;
import railcraft.common.blocks.signals.TileBoxBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileBoxCapacitor
extends TileBoxBase
implements IGuiReturnHandler {
    protected int update = MiscTools.getRand().nextInt();
    private short ticksPowered;
    public short ticksToPower = (short)200;

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CAPACITOR;
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        if (player.ah()) {
            return false;
        }
        ur current = player.bS();
        if (current != null && current.b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_CAPACITOR, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public void g() {
        ++this.update;
        if (Game.isNotHost(this.k)) {
            return;
        }
        if (this.ticksPowered > 0) {
            this.ticksPowered = (short)(this.ticksPowered - 1);
            if (this.ticksPowered <= 0) {
                this.updateNeighbors();
            }
        }
    }

    @Override
    public void onNeighborStateChange(TileBoxBase neighbor) {
        if (neighbor.isEmitingRedstone()) {
            this.ticksPowered = this.ticksToPower;
            this.updateNeighbors();
        }
    }

    private void updateNeighbors() {
        this.sendUpdateToClient();
        int blockID = this.getBlockId();
        this.k.h(this.l, this.m, this.n, blockID);
    }

    @Override
    public boolean isPoweringTo(ym world, int i, int j, int k, int side) {
        any tile = MiscTools.getBlockTileEntityOnSide(this.k, i, j, k, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return false;
        }
        return this.ticksPowered > 0;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("ticksPowered", this.ticksPowered);
        data.a("ticksToPower", this.ticksToPower);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.ticksPowered = data.d("ticksPowered");
        this.ticksToPower = data.d("ticksToPower");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.ticksPowered > 0);
        data.writeShort(this.ticksToPower);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.ticksPowered = (short)(data.readBoolean() ? 1 : 0);
        this.ticksToPower = data.readShort();
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.ticksToPower);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.ticksToPower = data.readShort();
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        any tile = this.k.q(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.ticksPowered > 0 ? SignalAspect.RED : SignalAspect.OFF;
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }
}

