/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.util.HashMap;
import java.util.Map;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.blocks.signals.SignalBlock;

public class SignalBlockRelay
extends SignalBlock {
    private Map aspects = new HashMap();

    public SignalBlockRelay(RailcraftTileEntity tile) {
        super(tile, 2);
    }

    @Override
    protected void updateSignalAspect() {
        this.aspects.keySet().retainAll(this.pairings);
        for (WorldCoordinate otherCoord : this.pairings) {
            this.aspects.put(otherCoord, this.determineAspect(otherCoord));
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        if (this.isWaitingForRetest() || this.isBeingPaired()) {
            return SignalAspect.BLINK_YELLOW;
        }
        if (!this.isPaired()) {
            return SignalAspect.BLINK_RED;
        }
        SignalAspect aspect = SignalAspect.GREEN;
        for (WorldCoordinate otherCoord : this.pairings) {
            aspect = SignalAspect.mostRestrictive(aspect, (SignalAspect)((Object)this.aspects.get(otherCoord)));
        }
        return aspect;
    }

    @Override
    protected SignalAspect getSignalAspectForPair(WorldCoordinate otherCoord) {
        SignalAspect aspect = SignalAspect.GREEN;
        for (Map.Entry entry : this.aspects.entrySet()) {
            if (((WorldCoordinate)entry.getKey()).equals(otherCoord)) continue;
            aspect = SignalAspect.mostRestrictive(aspect, (SignalAspect)((Object)entry.getValue()));
        }
        return aspect;
    }
}

