/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.PipeManager;
import ic2.api.IWrenchable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.ILiquidTransfer;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackLockdown;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.carts.EntityCartTank;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankToolkit;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.misc.SafeNBTWrapper;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileLiquidLoader
extends TileLoaderLiquidBase
implements IWrenchable,
ISidedInventory,
ISpecialInventory,
IGuiReturnHandler {
    private static final int TRANSFER_RATE = 20;
    private static final int CAPACITY = 8000;
    private static final float MAX_PIPE_LENGTH = 1.0f;
    private static final float PIPE_INCREMENT = 0.01f;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private static final int RESET_TICKS = 10;
    private boolean waitTillFull = true;
    private boolean waitIfEmpty = true;
    private boolean waitForReset = false;
    private float pipeLenght = 0.0f;
    private final la invInput = new InventoryMapper(this, 0, 1);
    private StandardTank tank = new StandardTank(8000, this);

    public TileLiquidLoader() {
        this.tank.setTankPressure(-1);
        this.tankManager.addTank(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_LOADER;
    }

    public la getInputInventory() {
        return this.invInput;
    }

    private void resetPipe() {
        this.pipeLenght = 0.0f;
    }

    public float getPipeLenght() {
        return this.pipeLenght;
    }

    private void setPipeLength(float y) {
        this.pipeLenght = y;
        this.sendUpdateToClient();
    }

    private void extendPipe() {
        float y = this.pipeLenght + 0.01f;
        if (this.pipeIsExtended()) {
            y = 1.0f;
        }
        this.setPipeLength(y);
    }

    private void retractPipe() {
        float y = this.pipeLenght - 0.01f;
        if (this.pipeIsRetracted()) {
            y = 0.0f;
        }
        this.setPipeLength(y);
    }

    private boolean pipeIsExtended() {
        return this.pipeLenght >= 1.0f;
    }

    private boolean pipeIsRetracted() {
        return this.pipeLenght <= 0.0f;
    }

    @Override
    public int getBlockTexture(int side) {
        if (side > 1) {
            return 24;
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void g() {
        LiquidStack drained;
        EntityLocomotiveSteam loco;
        ur bottomSlot;
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ur topSlot = this.a(0);
        if (topSlot != null && !LiquidManager.getInstance().isContainer(topSlot)) {
            this.a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.a(1)) != null && !LiquidManager.getInstance().isContainer(bottomSlot)) {
            this.a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.update % 8 == 0) {
            LiquidManager.getInstance().processContainers(this.tankManager.getTank(0), this, 0, 1, true, false);
        }
        for (ForgeDirection side : ForgeDirection.values()) {
            any tile;
            if (side == ForgeDirection.UNKNOWN || !((tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, side)) instanceof ITankContainer)) continue;
            ITankContainer nearbyTank = (ITankContainer)tile;
            if (!PipeManager.canExtractLiquids(null, this.k, MiscTools.getXOnSide(this.l, side), MiscTools.getYOnSide(this.m, side), MiscTools.getZOnSide(this.n, side))) continue;
            side = side.getOpposite();
            LiquidStack drained2 = nearbyTank.drain(side, 20, false);
            int used = this.tank.fill(drained2, true);
            nearbyTank.drain(side, used, true);
        }
        boolean needsPipe = false;
        py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.2f, ForgeDirection.DOWN);
        if (cart == null) {
            cart = CartTools.getMinecartOnSide(this.k, this.l, this.m - 1, this.n, 0.2f, ForgeDirection.DOWN);
            needsPipe = true;
        }
        if (cart != this.currentCart) {
            if (this.currentCart instanceof ILiquidTransfer) {
                ((EntityCartTank)this.currentCart).setFilling(false);
            }
            this.setPowered(false);
            this.currentCart = cart;
            this.cartSent();
            this.waitForReset = false;
        }
        if (this.waitForReset) {
            if (this.pipeIsRetracted()) {
                this.sendCart(cart);
            } else {
                this.retractPipe();
            }
            return;
        }
        if (cart == null) {
            if (!this.pipeIsRetracted()) {
                this.retractPipe();
            }
            return;
        }
        if (this.isSendCart()) {
            this.sendCart(cart);
            return;
        }
        if (!(cart instanceof ITankContainer)) {
            this.sendCart(cart);
            return;
        }
        ur minecartSlot1 = this.getCartFilters().a(0);
        ur minecartSlot2 = this.getCartFilters().a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            this.sendCart(cart);
            return;
        }
        if (cart instanceof EntityLocomotiveSteam && !(loco = (EntityLocomotiveSteam)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        TankToolkit tankCart = new TankToolkit((ITankContainer)cart);
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        int flow = 0;
        if (cartNeedsFilling && (!needsPipe || this.pipeIsExtended()) && (drained = this.tankManager.drain(0, RailcraftConfig.getTankCartFillRate(), false)) != null) {
            flow = tankCart.fill(ForgeDirection.UP, drained, true);
            this.tankManager.drain(0, flow, true);
        }
        if (flow > 0) {
            if (cart instanceof ILiquidTransfer) {
                ((EntityCartTank)cart).setFilling(true);
            }
            this.setPowered(false);
        } else if (cart instanceof ILiquidTransfer) {
            ((EntityCartTank)cart).setFilling(false);
        }
        if (tankCart.isTankFull(this.tank.getLiquid())) {
            this.waitForReset = true;
        }
        if (this.pipeIsRetracted() && flow <= 0 && this.shouldCartLeave(cart, tankCart)) {
            this.sendCart(cart);
        }
    }

    private void sendCart(py cart) {
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            this.setPowered(true);
        }
    }

    private boolean cartNeedsFilling(TankToolkit tankCart) {
        LiquidStack loaderLiquid = this.tank.getLiquid();
        return loaderLiquid != null && loaderLiquid.amount > 0 && tankCart.canPutLiquid(ForgeDirection.UP, loaderLiquid);
    }

    private boolean shouldCartLeave(py cart, TankToolkit tankCart) {
        boolean leave = false;
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (this.tank.getLiquid() != null && this.tank.getLiquid().amount > 0 && !tankCart.canPutLiquid(ForgeDirection.UP, this.tank.getLiquid())) {
                leave = true;
            } else if (!this.waitTillFull && !tankCart.isTankEmpty(this.tank.getLiquid())) {
                leave = true;
            } else if (!this.waitIfEmpty && !this.waitTillFull && tankCart.isTankEmpty(this.tank.getLiquid())) {
                leave = true;
            } else if (tankCart.isTankFull(this.tank.getLiquid())) {
                leave = true;
            }
        }
        return leave;
    }

    @Override
    protected void setPowered(boolean p) {
        if (p) {
            TileTrack trackTile;
            ITrackInstance track;
            any tile;
            this.resetPipe();
            if (this.k != null && (tile = this.k.q(this.l, this.m - 2, this.n)) instanceof TileTrack && (track = (trackTile = (TileTrack)tile).getTrackInstance()) instanceof ITrackLockdown) {
                ((ITrackLockdown)track).releaseCart();
            }
        }
        super.setPowered(p);
    }

    public void w_() {
        super.w_();
        this.resetPipe();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.resetPipe();
    }

    @Override
    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("WaitIfEmpty", this.waitIfEmpty);
        data.a("WaitTillFull", this.waitTillFull);
        data.a("pipeLenght", this.pipeLenght);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.waitIfEmpty = data.n("WaitIfEmpty");
        this.waitTillFull = data.n("WaitTillFull");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.pipeLenght = safe.getFloat("pipeLenght");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        byte bits = 0;
        bits = (byte)(bits | (this.waitIfEmpty ? 1 : 0));
        bits = (byte)(bits | (this.waitTillFull ? 2 : 0));
        data.writeByte(bits);
        data.writeFloat(this.pipeLenght);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte bits = data.readByte();
        this.waitIfEmpty = (bits & 1) != 0;
        this.waitTillFull = (bits & 2) != 0;
        this.setPipeLength(data.readFloat());
    }

    public boolean waitTillFull() {
        return this.waitTillFull;
    }

    public void setWaitTillFull(boolean waitTillFull) {
        this.waitTillFull = waitTillFull;
    }

    public boolean waitIfEmpty() {
        return this.waitIfEmpty;
    }

    public void setWaitIfEmpty(boolean waitIfEmpty) {
        this.waitIfEmpty = waitIfEmpty;
    }

    @Override
    public short getFacing() {
        return (short)ForgeDirection.DOWN.ordinal();
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.LOADER_LIQUID, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (LiquidManager.getInstance().isFilledContainer(stack)) {
            ur ret;
            Object slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((la)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.l(), slot)) != null && stack.a != ret.a) {
                return stack.a - ret.a;
            }
            if (ret == null) {
                return stack.a;
            }
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return new ur[]{inv.a(1, maxItemCount)};
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitIfEmpty);
        data.writeBoolean(this.waitTillFull);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.waitIfEmpty = data.readBoolean();
        this.waitTillFull = data.readBoolean();
    }
}

