/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.TileEngine;
import railcraft.common.blocks.machine.beta.TileEngineSteam;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.indicator.IIndicatorController;
import railcraft.common.gui.util.ToolTip;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankWrapper;
import railcraft.common.liquids.tanks.FilteredTank;
import railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import railcraft.common.plugins.buildcraft.triggers.ITemperature;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileEngineSteamHobby
extends TileEngineSteam
implements la,
ISidedInventory,
ISpecialInventory,
INeedsFuel,
ITemperature {
    private static final float OUTPUT_MJ = 2.0f;
    private static final byte FUEL_PER_CONVERSION = 8;
    private static final byte TICKS_PER_CONVERSION = 20;
    private static final byte TANK_WATER = 1;
    private static final byte SLOT_FUEL = 0;
    private static final byte SLOT_LIQUID_INPUT = 1;
    private static final byte SLOT_LIQUID_OUTPUT = 2;
    public float burnTime;
    public float currentItemBurnTime;
    private int burnCycle;
    public float heat = 20.0f;
    private int update;
    private final LiquidStack waterFilter = new LiquidStack(amq.E, 0);
    private final LiquidStack steamFilter = LiquidItems.getSteamLiquid();
    private StandaloneInventory inv = new StandaloneInventory(3, this);
    private IIndicatorController heatIndicator = new HeatIndicator();

    public TileEngineSteamHobby() {
        this.getTankManager().addTank(new FilteredTank(4000, this.waterFilter));
        this.getTankManager().getTank(0).setCapacity(4000);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.ENGINE_STEAM_HOBBY;
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.ENGINE_HOBBY, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        ur current = player.bS();
        if (current != null && current.c != up.aw.cj && (Game.isHost(this.k) ? LiquidManager.getInstance().handleRightClick(this, 1, player, true, false) : LiquidManager.getInstance().isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    public IIndicatorController getHeatIndicator() {
        return this.heatIndicator;
    }

    public boolean isBurning() {
        return this.burnTime > 0.0f;
    }

    @Override
    public float getMaxOutputMJ() {
        return 2.0f;
    }

    @Override
    public int steamUsedPerTick() {
        return 10;
    }

    @Override
    public void burn() {
        super.burn();
        ++this.update;
        if (this.update % 8 == 0) {
            LiquidManager.getInstance().processContainers(this, 1, this.inv, 1, 2, true, false);
        }
        ++this.burnCycle;
        if (this.burnCycle >= 20) {
            LiquidStack water;
            boolean addedFuel;
            this.burnCycle = 0;
            float fuelNeeded = this.getFuelPerConversion();
            while (this.burnTime < fuelNeeded && (addedFuel = this.addFuel())) {
            }
            this.burnTime -= fuelNeeded;
            if (this.burnTime <= 0.0f) {
                this.burnTime = 0.0f;
            }
            if (this.heat >= 100.0f && (water = this.getTankManager().drain(1, 1, false)) != null) {
                this.getTankManager().drain(1, 1, true);
                LiquidStack steam = LiquidItems.getSteamLiquid(160);
                this.getTankManager().fill(0, steam, true);
            }
        }
        if (this.isBurning()) {
            this.increaseHeat();
        } else {
            this.reduceHeat();
        }
    }

    private boolean addFuel() {
        if (!this.isPowered()) {
            return false;
        }
        if (this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
            return false;
        }
        int fuel = this.getMoreFuel();
        this.burnTime += (float)fuel;
        this.currentItemBurnTime = this.burnTime;
        return fuel > 0;
    }

    protected int getMoreFuel() {
        ur fuel = this.a(0);
        int burn = MiscTools.getItemBurnTime(fuel);
        if (burn > 0) {
            this.a(0, InvTools.depleteItem(fuel));
        }
        return burn;
    }

    public int getFuelPerConversion() {
        float fuel = 8.0f;
        fuel += fuel * (8.0f - 8.0f * this.getHeatLevel());
        return Math.round(fuel);
    }

    public float getHeatLevel() {
        return this.heat / 500.0f;
    }

    private void increaseHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat += 0.05f;
        if (heatLevel < 0.25f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.5f) {
            this.heat += 0.05f;
        }
        if (heatLevel < 0.75f) {
            this.heat += 0.05f;
        }
        this.heat = Math.min(this.heat, 500.0f);
    }

    private void reduceHeat() {
        float heatLevel = this.getHeatLevel();
        this.heat -= 0.05f;
        if (heatLevel > 0.25f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.5f) {
            this.heat -= 0.05f;
        }
        if (heatLevel > 0.75f) {
            this.heat -= 0.05f;
        }
        this.heat = Math.max(this.heat, 20.0f);
    }

    public int getBurnProgressScaled(int i) {
        return (int)(this.burnTime / this.currentItemBurnTime * (float)i);
    }

    public int k_() {
        return this.inv.k_();
    }

    public ur a(int slot) {
        return this.inv.a(slot);
    }

    public ur a(int slot, int amount) {
        return this.inv.a(slot, amount);
    }

    public ur a_(int var1) {
        return null;
    }

    public void a(int slot, ur stack) {
        this.inv.a(slot, stack);
    }

    @Override
    public String b() {
        return RailcraftLanguage.translate(EnumMachineBeta.ENGINE_STEAM_HOBBY.getTag());
    }

    public int c() {
        return 64;
    }

    public void l_() {
    }

    public void f() {
    }

    @Override
    public int maxEnergy() {
        return 10000;
    }

    @Override
    public int maxEnergyReceived() {
        return 300;
    }

    @Override
    public int maxEnergyExtracted() {
        return 40;
    }

    @Override
    public boolean needsFuel() {
        ur fuel = this.inv.a(0);
        return fuel == null || fuel.a < 8;
    }

    @Override
    public float getTemperature() {
        return this.heat;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.inv.writeToNBT("Items", data);
        data.a("heat", this.heat);
        data.a("burnTime", this.burnTime);
        data.a("currentItemBurnTime", this.currentItemBurnTime);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.inv.readFromNBT("Items", data);
        this.heat = data.g("heat");
        this.burnTime = data.g("burnTime");
        this.currentItemBurnTime = data.g("currentItemBurnTime");
    }

    public int getStartInventorySide(ForgeDirection side) {
        switch (side) {
            case UP: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        ur ret;
        Object slot;
        if (LiquidManager.getInstance().isFilledContainer(stack)) {
            slot = new InventoryMapper(this, 1, 1);
            if (!doAdd) {
                slot = new InventoryCopy((la)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.l(), slot)) != null && stack.a != ret.a) {
                return stack.a - ret.a;
            }
            if (ret == null) {
                return stack.a;
            }
        }
        if (MiscTools.getItemBurnTime(stack) > 0) {
            slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((la)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.l(), slot)) != null && stack.a != ret.a) {
                return stack.a - ret.a;
            }
            if (ret == null) {
                return stack.a;
            }
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la outputInv = this;
        if (!doRemove) {
            outputInv = new InventoryCopy(outputInv);
        }
        return new ur[]{outputInv.a(2, maxItemCount)};
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.isPowered() && this.steamFilter.isLiquidEqual(resource)) {
            return this.fill(0, resource, doFill);
        }
        if (this.waterFilter.isLiquidEqual(resource)) {
            return this.fill(1, resource, doFill);
        }
        return 0;
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        LiquidStack water;
        if (tankIndex == 1 && this.heat >= 300.0f && ((water = this.getTankManager().getTank(1).getLiquid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return super.fill(tankIndex, resource, doFill);
    }

    @Override
    public ILiquidTank getTank(ForgeDirection side, LiquidStack type) {
        switch (side) {
            case UP: 
            case DOWN: {
                return this.getTankManager().getTank(0);
            }
        }
        return new WaterTankWrapper((ILiquidTank)this.getTankManager().getTank(1));
    }

    public void explode() {
        if (Game.isHost(this.k)) {
            this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 2.0f, true);
        }
    }

    protected class WaterTankWrapper
    extends TankWrapper {
        public WaterTankWrapper(ILiquidTank tank) {
            super(tank);
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            LiquidStack water;
            if (resource == null) {
                return 0;
            }
            if (TileEngineSteamHobby.this.heat >= 300.0f && ((water = this.tank.getLiquid()) == null || water.amount <= 0)) {
                TileEngineSteamHobby.this.explode();
            }
            return this.tank.fill(resource, doFill);
        }
    }

    private class HeatIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private HeatIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%.0f\u00b0C", Float.valueOf(TileEngineSteamHobby.this.heat));
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            return (int)((TileEngineSteamHobby.this.heat - 20.0f) * (float)size / 480.0f);
        }
    }
}

