/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.beta.ISteamUser;
import railcraft.common.blocks.machine.beta.TileEngine;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FilteredTank;
import railcraft.common.util.effects.EffectManager;

public abstract class TileEngineSteam
extends TileEngine
implements ITankContainer,
ISteamUser {
    private static final int TANK_CAPACITY = 8000;
    public static final int TANK_STEAM = 0;
    private final FilteredTank steamTank;
    private TankManager tankManager = new TankManager();
    private int steamUsed;

    public TileEngineSteam() {
        this.steamTank = new FilteredTank(8000, LiquidItems.getSteamLiquid());
        this.tankManager.addTank(this.steamTank);
    }

    private int getParticleRate() {
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 1;
            }
            case GREEN: {
                return 2;
            }
            case YELLOW: {
                return 3;
            }
            case ORANGE: {
                return 4;
            }
            case RED: {
                return 5;
            }
            case OVERHEAT: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.ENGINE_STEAM, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random rand) {
        if (this.isActive() || this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
            int steamRate = this.getParticleRate();
            for (int i = 0; i < steamRate; ++i) {
                EffectManager.instance.steamEffect(this.k, this, 0.0);
            }
        }
    }

    @Override
    public void burn() {
        float output = 0.0f;
        if (this.getEnergyStage() != TileEngine.EnergyStage.OVERHEAT) {
            LiquidStack steam;
            if (this.isPowered() && (steam = this.steamTank.getLiquid()) != null && steam.amount >= this.steamTank.getCapacity() / 2 - 160 && (steam = this.tankManager.drain(0, this.steamUsedPerTick() - 1, true)) != null) {
                this.steamUsed += steam.amount;
            }
            if ((steam = this.tankManager.drain(0, 1, true)) != null) {
                this.steamUsed += steam.amount;
            }
            if (this.isPowered()) {
                if (this.steamUsed >= this.steamUsedPerTick()) {
                    this.steamUsed -= this.steamUsedPerTick();
                    output = this.getMaxOutputMJ();
                    this.addEnergy(this.getMaxOutputMJ());
                }
            } else {
                this.steamUsed = 0;
                this.ventSteam();
            }
        }
        this.currentOutput = (this.currentOutput * 74.0f + output) / 75.0f;
    }

    @Override
    protected void overheat() {
        super.overheat();
        this.ventSteam();
    }

    protected void ventSteam() {
        this.getTankManager().drain(0, 5, true);
    }

    public abstract float getMaxOutputMJ();

    public abstract int steamUsedPerTick();

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (!this.isPowered()) {
            return 0;
        }
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.tankManager.fill(tankIndex, resource, doFill);
    }

    public ILiquidTank[] getTanks(ForgeDirection dir) {
        return this.tankManager.getTanks();
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tankManager.getTank(0);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }
}

