/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.ITankTile;
import railcraft.common.blocks.machine.TileMultiBlockInventory;
import railcraft.common.gui.slots.SlotLiquidContainer;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.util.misc.MiscTools;

public abstract class TileTank
extends TileMultiBlockInventory
implements ITankContainer,
ISidedInventory,
ITankTile {
    protected final TankManager tankManager = new TankManager();
    private boolean testOutput = true;

    public TileTank(String name, int invNum, List patterns) {
        super(name, invNum, patterns);
    }

    @Override
    public la getInventory() {
        return this;
    }

    @Override
    public TankManager getTankManager() {
        TileTank mBlock = (TileTank)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager;
        }
        return null;
    }

    @Override
    public ILiquidTank getTank() {
        TileTank mBlock = (TileTank)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.tankManager.getTank(0);
        }
        return null;
    }

    @Override
    public sr getInputSlot(la inv, int id, int x, int y) {
        return new SlotLiquidContainer(inv, id, x, y);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTank(0);
        }
        return FakeTank.INSTANCE;
    }

    public ITankContainer getOutputOnSide(ForgeDirection side) {
        IPipe pipe;
        any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, side);
        if (tile instanceof TileTank) {
            return null;
        }
        if (tile instanceof ITankContainer) {
            return (ITankContainer)tile;
        }
        if (tile instanceof IPipeTile && (pipe = ((IPipeTile)tile).getPipe()) instanceof ITankContainer) {
            return (ITankContainer)pipe;
        }
        return null;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.tankManager.writeTanksToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.tankManager.readTanksFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.tankManager.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.tankManager.readPacketData(data);
    }
}

