/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.blocks.machine.TileMultiBlockInventory;

public abstract class TileMultiBlockOven
extends TileMultiBlockInventory
implements ISidedInventory {
    protected int cookTime;
    protected boolean cooking;
    private boolean wasBurning;

    public TileMultiBlockOven(String name, int invNum, List patterns) {
        super(name, invNum, patterns);
    }

    @Override
    public void g() {
        super.g();
        if (this.getPatternMarker() == 'W' && this.update % 4 == 0) {
            this.updateLighting();
        }
    }

    protected void updateLighting() {
        boolean b = this.isBurning();
        if (this.wasBurning != b) {
            this.wasBurning = b;
            this.k.c(yo.b, this.l, this.m, this.n);
            this.markBlockForUpdate();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(Random random) {
        this.updateLighting();
        if (this.getPatternMarker() == 'W' && this.isStructureValid() && random.nextInt(100) < 20 && this.isBurning()) {
            float f = (float)this.l + 0.5f;
            float f1 = (float)this.m + 0.4375f + random.nextFloat() * 3.0f / 16.0f;
            float f2 = (float)this.n + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            this.k.a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            this.k.a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            this.k.a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            this.k.a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("cookTime", this.cookTime);
        data.a("cooking", this.cooking);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.cookTime = data.e("cookTime");
        this.cooking = data.n("cooking");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeInt(this.cookTime);
        data.writeBoolean(this.cooking);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.cookTime = data.readInt();
        this.cooking = data.readBoolean();
    }

    public int getCookTime() {
        TileMultiBlockOven masterOven = (TileMultiBlockOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cookTime;
        }
        return -1;
    }

    public boolean isCooking() {
        TileMultiBlockOven masterOven = (TileMultiBlockOven)this.getMasterBlock();
        if (masterOven != null) {
            return masterOven.cooking;
        }
        return false;
    }

    public boolean isBurning() {
        return this.isCooking();
    }

    public void setCooking(boolean c) {
        if (this.cooking != c) {
            this.cooking = c;
            this.sendUpdateToClient();
        }
    }

    public void setCookTime(int i) {
        this.cookTime = i;
    }

    public abstract int getTotalCookTime();

    public int getCookProgressScaled(int i) {
        if (this.cookTime == 0 || this.getTotalCookTime() == 0) {
            return 0;
        }
        int scale = this.cookTime * i / this.getTotalCookTime();
        scale = Math.min(scale, i);
        scale = Math.max(scale, 0);
        return scale;
    }

    public abstract int getBurnProgressScaled(int var1);

    @Override
    public int getLightValue() {
        if (this.getPatternMarker() == 'W' && this.isStructureValid() && this.isBurning()) {
            return 13;
        }
        return 0;
    }
}

