/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.detector;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import railcraft.common.api.core.items.ITrackItem;
import railcraft.common.blocks.detector.TileDetector;
import railcraft.common.blocks.detector.TileDetectorAdvanced;
import railcraft.common.blocks.detector.TileDetectorAnimal;
import railcraft.common.blocks.detector.TileDetectorItem;
import railcraft.common.blocks.detector.TileDetectorLocomotive;
import railcraft.common.blocks.detector.TileDetectorSheep;
import railcraft.common.blocks.detector.TileDetectorTank;
import railcraft.common.blocks.detector.TileDetectorTrain;
import railcraft.common.blocks.detector.TileDetectorVillager;
import railcraft.common.items.IActivationBlockingItem;
import railcraft.common.modules.ModuleManager;
import railcraft.common.plugins.forge.CreativePlugin;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class BlockDetector
extends akb {
    protected static final int[][] texture = new int[Detector.values().length][3];

    public BlockDetector(int blockID) {
        super(blockID, 12, agi.e);
        for (int i = 0; i < texture.length - 1; ++i) {
            for (int j = 0; j < texture[i].length; ++j) {
                BlockDetector.texture[i][j] = 13 + i * 16 + j;
            }
        }
        for (int j = 0; j < texture[15].length; ++j) {
            BlockDetector.texture[15][j] = 234 + j;
        }
        this.b(4.5f);
        this.c(2.0f);
        this.a(h);
        this.r();
        this.a(CreativePlugin.TAB);
        GameRegistry.registerTileEntity(TileDetector.class, (String)"RCDetectorTile");
        GameRegistry.registerTileEntity(TileDetectorItem.class, (String)"RCDetectorItemTile");
        GameRegistry.registerTileEntity(TileDetectorAdvanced.class, (String)"RCDetectorAdvancedTile");
        GameRegistry.registerTileEntity(TileDetectorTank.class, (String)"RCDetectorTankTile");
        GameRegistry.registerTileEntity(TileDetectorAnimal.class, (String)"RCDetectorAnimalTile");
        GameRegistry.registerTileEntity(TileDetectorTrain.class, (String)"RCDetectorTrainTile");
        GameRegistry.registerTileEntity(TileDetectorSheep.class, (String)"RCDetectorSheepTile");
        GameRegistry.registerTileEntity(TileDetectorVillager.class, (String)"RCDetectorVillagerTile");
        GameRegistry.registerTileEntity(TileDetectorLocomotive.class, (String)"RCDetectorLocomotiveTile");
        MinecraftForge.setBlockHarvestLevel((amq)this, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((amq)this, (String)"crowbar", (int)0);
    }

    public String getTextureFile() {
        return "/railcraft/client/textures/railcraft.png";
    }

    public static String getBlockNameFromMetadata(int meta) {
        StringBuilder name = new StringBuilder("detector.");
        name.append(Detector.fromMeta(meta).name().toLowerCase());
        return name.toString();
    }

    public boolean isBlockNormalCube(yc world, int i, int j, int k) {
        return false;
    }

    public boolean isBlockSolidOnSide(yc world, int i, int j, int k, ForgeDirection side) {
        return true;
    }

    public int b(int meta) {
        return meta;
    }

    public any a(yc var1) {
        return null;
    }

    public any createNewTileEntity(yc var1, int meta) {
        switch (Detector.values()[meta]) {
            case ITEM: {
                return new TileDetectorItem();
            }
            case ADVANCED: {
                return new TileDetectorAdvanced();
            }
            case TANK: {
                return new TileDetectorTank();
            }
            case ANIMAL: {
                return new TileDetectorAnimal();
            }
            case TRAIN: {
                return new TileDetectorTrain();
            }
            case SHEEP: {
                return new TileDetectorSheep();
            }
            case VILLAGER: {
                return new TileDetectorVillager();
            }
            case LOCOMOTIVE: {
                return new TileDetectorLocomotive();
            }
        }
        return new TileDetector();
    }

    public void a(yc world, int i, int j, int k, md entityliving) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileDetector) {
            ((TileDetector)tile).direction = MiscTools.getSideClosestToPlayer(world, i, j, k, entityliving);
            ((TileDetector)tile).onBlockPlacedBy(entityliving);
        }
    }

    public boolean a(yc world, int x, int y, int z, qx player, int side, float u1, float u2, float u3) {
        any tile;
        if (player.ah()) {
            return false;
        }
        ur current = player.bS();
        if (current != null) {
            up item = current.b();
            if (item instanceof IActivationBlockingItem) {
                return false;
            }
            if (item instanceof IToolWrench) {
                any t;
                if (Game.isNotHost(world)) {
                    return true;
                }
                IToolWrench wrench = (IToolWrench)item;
                if (wrench.canWrench(player, x, y, z) && (t = world.q(x, y, z)) instanceof TileDetector) {
                    TileDetector tile2 = (TileDetector)t;
                    tile2.direction = tile2.direction.ordinal() == side ? tile2.direction.getOpposite() : ForgeDirection.getOrientation((int)side);
                    wrench.wrenchUsed(player, x, y, z);
                    world.i(x, y, z);
                    return true;
                }
            } else if (item.cj < amq.p.length && alr.e((int)item.cj) || item instanceof ITrackItem) {
                return false;
            }
        }
        if ((tile = world.q(x, y, z)) instanceof TileDetector) {
            return ((TileDetector)tile).blockActivated(player);
        }
        return false;
    }

    public int d(ym world, int i, int j, int k, int side) {
        any t;
        int meta = world.h(i, j, k);
        if (meta >= texture.length || meta < 0) {
            meta = 0;
        }
        if ((t = world.q(i, j, k)) instanceof TileDetector && ((TileDetector)t).direction.ordinal() == side) {
            if (((TileDetector)t).powered) {
                return texture[meta][2];
            }
            return texture[meta][1];
        }
        return texture[meta][0];
    }

    public int a(int side, int meta) {
        if (meta >= texture.length || meta < 0) {
            return texture[0][1];
        }
        if (side == 3) {
            return texture[meta][2];
        }
        return texture[meta][0];
    }

    public boolean i() {
        return true;
    }

    public boolean b(ym world, int i, int j, int k, int side) {
        any t = world.q(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (tile.direction == MiscTools.getOppositeSide(side)) {
                return tile.powered;
            }
        }
        return false;
    }

    public boolean c(ym world, int i, int j, int k, int side) {
        return this.b(world, i, j, k, side);
    }

    public void g(yc world, int i, int j, int k) {
        super.g(world, i, j, k);
        world.i(i, j, k);
        if (Game.isNotHost(world)) {
            return;
        }
        world.h(i + 1, j, k, this.cm);
        world.h(i - 1, j, k, this.cm);
        world.h(i, j, k + 1, this.cm);
        world.h(i, j, k - 1, this.cm);
        world.h(i, j - 1, k, this.cm);
        world.h(i, j + 1, k, this.cm);
        world.a(i, j, k, this.cm, this.r_());
    }

    public void a(yc world, int i, int j, int k, int id, int metadata) {
        super.a(world, i, j, k, id, metadata);
        if (Game.isNotHost(world)) {
            return;
        }
        any t = world.q(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            tile.onBlockRemoval();
        }
        world.h(i + 1, j, k, this.cm);
        world.h(i - 1, j, k, this.cm);
        world.h(i, j, k + 1, this.cm);
        world.h(i, j, k - 1, this.cm);
        world.h(i, j - 1, k, this.cm);
        world.h(i, j + 1, k, this.cm);
    }

    public boolean canConnectRedstone(ym world, int i, int j, int k, int dir) {
        any t = world.q(i, j, k);
        if (t instanceof TileDetector) {
            TileDetector tile = (TileDetector)t;
            if (dir == 1 && tile.direction.ordinal() == 5) {
                return true;
            }
            if (dir == 3 && tile.direction.ordinal() == 4) {
                return true;
            }
            if (dir == 2 && tile.direction.ordinal() == 3) {
                return true;
            }
            if (dir == 0 && tile.direction.ordinal() == 2) {
                return true;
            }
        }
        return false;
    }

    public void a(int id, tj tab, List list) {
        for (Detector d : Detector.values()) {
            if (d == Detector.ENERGY && !ModuleManager.isModuleLoaded(ModuleManager.Module.IC2) || d == Detector.TRAIN && !ModuleManager.isModuleLoaded(ModuleManager.Module.TRAIN)) continue;
            list.add(new ur(this.cm, 1, d.ordinal()));
        }
    }

    public static enum Detector {
        ITEM,
        ANY,
        EMPTY,
        MOB,
        POWERED,
        PLAYER,
        EXPLOSIVE,
        ANIMAL,
        TANK,
        ADVANCED,
        ENERGY,
        AGE,
        TRAIN,
        SHEEP,
        VILLAGER,
        LOCOMOTIVE;


        public static Detector fromMeta(int meta) {
            if (meta >= Detector.values().length) {
                meta = 0;
            }
            return Detector.values()[meta];
        }
    }
}

