/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.aesthetics.wall;

import railcraft.common.blocks.aesthetics.cube.EnumCube;
import railcraft.common.blocks.aesthetics.wall.BlockRailcraftWall;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.modules.ModuleManager;
import railcraft.common.plugins.forge.CraftingPlugin;

public enum EnumWall {
    INFERNAL(215, true),
    SANDY(214, true),
    CONCRETE(103, true),
    SNOW(66, false),
    ICE(67, false),
    STONE_BRICK(54, false),
    STONE_BRICK_MOSSY(100, false),
    STONE_BRICK_CRACKED(101, false),
    STONE_BRICK_CHISELED(213, false),
    NETHER_BRICK(224, false),
    BRICK(7, false),
    SANDSTONE(192, false),
    SANDSTONE_CHISELED(229, false),
    SANDSTONE_SMOOTH(230, false),
    OBSIDIAN(37, false);

    public static final EnumWall[] VALUES;
    private final int texture;
    private final boolean useBlockTexture;
    private ur source;

    public static void registerRecipes() {
        EnumWall.INFERNAL.source = EnumCube.INFERNAL_BRICK.getItem();
        EnumWall.SANDY.source = EnumCube.SANDY_BRICK.getItem();
        EnumWall.CONCRETE.source = EnumCube.CONCRETE_BLOCK.getItem();
        EnumWall.SNOW.source = new ur(amq.aX);
        EnumWall.ICE.source = new ur(amq.aW);
        EnumWall.STONE_BRICK.source = new ur(amq.bp, 1, 0);
        EnumWall.STONE_BRICK_MOSSY.source = new ur(amq.bp, 1, 1);
        EnumWall.STONE_BRICK_CRACKED.source = new ur(amq.bp, 1, 2);
        EnumWall.STONE_BRICK_CHISELED.source = new ur(amq.bp, 1, 3);
        EnumWall.NETHER_BRICK.source = new ur(amq.bD);
        EnumWall.BRICK.source = new ur(amq.ao);
        EnumWall.SANDSTONE.source = new ur(amq.T, 1, 0);
        EnumWall.SANDSTONE_CHISELED.source = new ur(amq.T, 1, 1);
        EnumWall.SANDSTONE_SMOOTH.source = new ur(amq.T, 1, 2);
        EnumWall.OBSIDIAN.source = new ur(amq.as);
        for (EnumWall wall : VALUES) {
            if (!wall.isEnabled()) continue;
            if (wall == NETHER_BRICK) {
                CraftingPlugin.addShapedRecipe(wall.getItem(5), "S S", "SSS", Character.valueOf('S'), wall.source);
                continue;
            }
            CraftingPlugin.addShapedRecipe(wall.getItem(6), "SSS", "SSS", Character.valueOf('S'), wall.source);
        }
    }

    /*
     * WARNING - void declaration
     */
    private EnumWall() {
        void useBlockTexture;
        void texture;
        this.texture = texture;
        this.useBlockTexture = useBlockTexture;
    }

    public static EnumWall fromMeta(int id) {
        if (id < 0 || id >= VALUES.length) {
            return VALUES[0];
        }
        return VALUES[id];
    }

    public boolean useBlockTexture() {
        return this.useBlockTexture;
    }

    public int getTexture() {
        return this.texture;
    }

    public int getSourceId() {
        if (this.source == null) {
            return 0;
        }
        return this.source.c;
    }

    public ur getItem() {
        return this.getItem(1);
    }

    public ur getItem(int qty) {
        BlockRailcraftWall block = BlockRailcraftWall.getBlock();
        if (block == null) {
            return null;
        }
        return new ur((amq)block, qty, this.ordinal());
    }

    public String getTag() {
        return "rc.wall." + this.name().replace("_", ".").toLowerCase();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(ModuleManager.Module.STRUCTURES) && RailcraftConfig.isSubBlockEnabled(this.getTag()) && BlockRailcraftWall.getBlock() != null;
    }

    static {
        VALUES = EnumWall.values();
    }
}

