/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;

public class SimpleSignalReceiver
extends SignalReceiver {
    private SignalAspect aspect = SignalAspect.BLINK_RED;

    public SimpleSignalReceiver(String desc, any tile) {
        super(desc, tile, 1);
    }

    public SignalAspect getAspect() {
        return this.aspect;
    }

    public void setAspect(SignalAspect aspect) {
        this.aspect = aspect;
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        if (this.aspect != aspect) {
            this.aspect = aspect;
            super.onControllerAspectChange(con, aspect);
        }
    }

    @Override
    protected void saveNBT(bq data) {
        super.saveNBT(data);
        data.a("aspect", (byte)this.aspect.ordinal());
    }

    @Override
    protected void loadNBT(bq data) {
        super.loadNBT(data);
        this.aspect = SignalAspect.values()[data.c("aspect")];
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        data.writeByte(this.aspect.ordinal());
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.aspect = SignalAspect.values()[data.readByte()];
    }
}

