/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.carts;

import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.api.core.items.IItemType;

public abstract class TransferCartBase
extends CartBase
implements IItemTransfer {
    protected boolean passThrough = false;

    public TransferCartBase(yc world) {
        super(world);
    }

    @Override
    public ur offerItem(Object source, ur offer) {
        if (!this.passThrough && this.k_() > 0 && (offer = this.moveItemStack(offer, (la)this)) == null) {
            return null;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        if (offer == null) {
            return null;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            offer = ((IItemTransfer)linkedCart).offerItem(this, offer);
        }
        return offer;
    }

    @Override
    public ur requestItem(Object source) {
        ur result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((la)this)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem(this);
        }
        return result;
    }

    @Override
    public ur requestItem(Object source, ur request) {
        ur result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((la)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    @Override
    public ur requestItem(Object source, IItemType request) {
        ur result = null;
        if (!this.passThrough && this.k_() > 0 && (result = this.removeOneItem((la)this, request)) != null) {
            return result;
        }
        ILinkageManager lm = CartTools.getLinkageManager(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        if (result != null) {
            return result;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof IItemTransfer) {
            result = ((IItemTransfer)linkedCart).requestItem((Object)this, request);
        }
        return result;
    }

    protected final ur removeOneItem(la inv) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final ur removeOneItem(la inv, ur filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null || filter == null || !slot.a(filter)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final ur removeOneItem(la inv, IItemType filter) {
        for (int i = 0; i < inv.k_(); ++i) {
            ur slot = inv.a(i);
            if (slot == null || !filter.isItemType(slot)) continue;
            return inv.a(i, 1);
        }
        return null;
    }

    protected final ur moveItemStack(ur stack, la dest) {
        if (stack == null) {
            return null;
        }
        stack = stack.l();
        if (dest == null) {
            return stack;
        }
        boolean movedItem = false;
        do {
            int ii;
            movedItem = false;
            ur destStack = null;
            for (ii = 0; ii < dest.k_(); ++ii) {
                int maxStack;
                int room;
                destStack = dest.a(ii);
                if (destStack == null || !destStack.a(stack) || (room = (maxStack = Math.min(destStack.d(), dest.c())) - destStack.a) <= 0) continue;
                int move = Math.min(room, stack.a);
                destStack.a += move;
                stack.a -= move;
                if (stack.a <= 0) {
                    return null;
                }
                movedItem = true;
            }
            if (movedItem) continue;
            for (ii = 0; ii < dest.k_(); ++ii) {
                destStack = dest.a(ii);
                if (destStack != null) continue;
                if (stack.a <= dest.c()) {
                    dest.a(ii, stack);
                    return null;
                }
                dest.a(ii, stack.a(dest.c()));
                movedItem = true;
            }
        } while (movedItem);
        return stack;
    }
}

