/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraftforge.client.ForgeHooksClient;
import railcraft.client.render.RenderFakeBlock;
import railcraft.client.render.RenderTools;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.blocks.tracks.TrackBufferStop;
import railcraft.common.blocks.tracks.TrackGated;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class RenderTrack
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(amq block, int metadata, int modelID, bbb renderer) {
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public int getRenderId() {
        return RailcraftBlocks.getBlockTrack().d();
    }

    public boolean renderWorldBlock(ym world, int i, int j, int k, amq block, int modelId, bbb renderblocks) {
        int meta = ((alr)block).getBasicRailMetadata(world, null, i, j, k);
        int texture = block.d(world, i, j, k, 0);
        boolean fallback = false;
        if (texture < 0) {
            texture = 128;
            fallback = true;
        }
        any tile = world.q(i, j, k);
        ITrackInstance track = null;
        if (tile instanceof TileTrack) {
            track = ((TileTrack)tile).getTrackInstance();
        } else {
            texture = 128;
            fallback = true;
        }
        if (renderblocks.d >= 0) {
            texture = renderblocks.d;
        }
        int j1 = (texture & 0xF) << 4;
        int k1 = texture & 0xF0;
        double uv1 = (float)j1 / 256.0f;
        double uv2 = ((float)j1 + 15.99f) / 256.0f;
        double uv3 = (float)k1 / 256.0f;
        double uv4 = ((float)k1 + 15.99f) / 256.0f;
        double d4 = 0.0625;
        double d5 = i + 1;
        double d6 = i + 1;
        double d7 = i + 0;
        double d8 = i + 0;
        double d9 = k + 0;
        double d10 = k + 1;
        double d11 = k + 1;
        double d12 = k + 0;
        double d13 = (double)j + d4;
        double d14 = (double)j + d4;
        double d15 = (double)j + d4;
        double d16 = (double)j + d4;
        if (meta != 1 && meta != 2 && meta != 3 && meta != 7) {
            if (meta == 8) {
                d5 = d6 = (double)(i + 0);
                d7 = d8 = (double)(i + 1);
                d9 = d12 = (double)(k + 1);
                d10 = d11 = (double)(k + 0);
            } else if (meta == 9) {
                d5 = d8 = (double)(i + 0);
                d6 = d7 = (double)(i + 1);
                d9 = d10 = (double)(k + 0);
                d11 = d12 = (double)(k + 1);
            }
        } else {
            d5 = d8 = (double)(i + 1);
            d6 = d7 = (double)(i + 0);
            d9 = d10 = (double)(k + 1);
            d11 = d12 = (double)(k + 0);
        }
        if (meta != 2 && meta != 4) {
            if (meta == 3 || meta == 5) {
                d14 += 1.0;
                d15 += 1.0;
            }
        } else {
            d13 += 1.0;
            d16 += 1.0;
        }
        if (track != null) {
            if (track instanceof ITrackSwitch) {
                ITrackSwitch switchTrack = (ITrackSwitch)track;
                if (switchTrack.isMirrored()) {
                    double temp = uv1;
                    uv1 = uv2;
                    uv2 = temp;
                    temp = uv3;
                    uv3 = uv4;
                    uv4 = temp;
                }
            } else if (track instanceof TrackGated) {
                RenderTrack.renderGatedTrack(renderblocks, (TrackGated)track, i, j, k, meta);
            } else if (track instanceof TrackBufferStop) {
                RenderTrack.renderBufferTrack(renderblocks, (TrackBufferStop)track, world, i, j, k, meta);
            }
            if (renderblocks.d < 0) {
                if (fallback) {
                    ForgeHooksClient.bindTexture((String)"/terrain.png", (int)0);
                } else {
                    ForgeHooksClient.bindTexture((String)track.getTrackSpec().getTextureFile(), (int)0);
                }
            }
        } else if (renderblocks.d < 0) {
            ForgeHooksClient.bindTexture((String)"/terrain.png", (int)0);
        }
        baz tessellator = baz.a;
        tessellator.c(block.e(world, i, j, k));
        tessellator.a(1.0f, 1.0f, 1.0f);
        tessellator.a(d5, d13, d9, uv2, uv3);
        tessellator.a(d6, d14, d10, uv2, uv4);
        tessellator.a(d7, d15, d11, uv1, uv4);
        tessellator.a(d8, d16, d12, uv1, uv3);
        tessellator.a(d8, d16, d12, uv1, uv3);
        tessellator.a(d7, d15, d11, uv1, uv4);
        tessellator.a(d6, d14, d10, uv2, uv4);
        tessellator.a(d5, d13, d9, uv2, uv3);
        ForgeHooksClient.unbindTexture();
        return true;
    }

    private static void renderBufferTrack(bbb render, TrackBufferStop track, ym world, int i, int j, int k, int meta) {
        boolean useTexture = false;
        if (render.d < 0) {
            useTexture = true;
            ForgeHooksClient.bindTexture((String)"/railcraft/client/textures/railcraft.png", (int)0);
        }
        float pix = 0.0625f;
        FakeBlockRenderInfo board = new FakeBlockRenderInfo();
        board.texture = new int[]{69};
        board.minX = pix * 2.0f;
        board.minY = pix * 6.0f;
        board.minZ = pix * 4.0f;
        board.maxX = pix * 14.0f;
        board.maxY = pix * 10.0f;
        board.maxZ = pix * 6.0f;
        FakeBlockRenderInfo bumper1 = new FakeBlockRenderInfo();
        bumper1.texture = new int[]{83};
        bumper1.minX = pix * 3.0f;
        bumper1.minY = pix * 7.0f;
        bumper1.minZ = pix * 3.0f;
        bumper1.maxX = pix * 5.0f;
        bumper1.maxY = pix * 9.0f;
        bumper1.maxZ = pix * 4.0f;
        FakeBlockRenderInfo bumper2 = new FakeBlockRenderInfo();
        bumper2.texture = new int[]{83};
        bumper2.minX = pix * 11.0f;
        bumper2.minY = pix * 7.0f;
        bumper2.minZ = pix * 3.0f;
        bumper2.maxX = pix * 13.0f;
        bumper2.maxY = pix * 9.0f;
        bumper2.maxZ = pix * 4.0f;
        FakeBlockRenderInfo baseBig = new FakeBlockRenderInfo();
        baseBig.texture = new int[]{84};
        baseBig.minX = pix * 4.0f;
        baseBig.minY = pix * 0.0f;
        baseBig.minZ = pix * 5.0f;
        baseBig.maxX = pix * 12.0f;
        baseBig.maxY = pix * 9.0f;
        baseBig.maxZ = pix * 9.0f;
        FakeBlockRenderInfo baseSmall = new FakeBlockRenderInfo();
        baseSmall.texture = new int[]{85};
        baseSmall.minX = pix * 5.0f;
        baseSmall.minY = pix * 0.0f;
        baseSmall.minZ = pix * 9.0f;
        baseSmall.maxX = pix * 11.0f;
        baseSmall.maxY = pix * 7.0f;
        baseSmall.maxZ = pix * 13.0f;
        if (meta == 0) {
            if (!track.isReversed()) {
                board.reverseZ();
                bumper1.reverseZ();
                bumper2.reverseZ();
                baseBig.reverseZ();
                baseSmall.reverseZ();
            }
        } else {
            board.texture = new int[]{68, 68, 69, 69, 69, 69};
            board.rotate();
            bumper1.rotate();
            bumper2.rotate();
            baseBig.rotate();
            baseSmall.rotate();
            if (track.isReversed()) {
                board.reverseX();
                bumper1.reverseX();
                bumper2.reverseX();
                baseBig.reverseX();
                baseSmall.reverseX();
            }
        }
        RenderFakeBlock.renderAsBlock(board, render, world, i, j, k);
        RenderFakeBlock.renderAsBlock(bumper1, render, world, i, j, k);
        RenderFakeBlock.renderAsBlock(bumper2, render, world, i, j, k);
        RenderFakeBlock.renderAsBlock(baseBig, render, world, i, j, k);
        RenderFakeBlock.renderAsBlock(baseSmall, render, world, i, j, k);
        if (useTexture) {
            // empty if block
        }
    }

    private static void renderGatedTrack(bbb render, TrackGated track, int i, int j, int k, int meta) {
        ForgeHooksClient.bindTexture((String)"/terrain.png", (int)0);
        boolean open = track.isGateOpen();
        amq gate = amq.by;
        if (meta == 0) {
            float f = 0.0f;
            float f8 = 0.125f;
            float f4 = 0.4375f;
            float f12 = 0.5625f;
            gate.a(f, 0.3125f, f4, f8, 1.0f, f12);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            f = 0.875f;
            f8 = 1.0f;
            gate.a(f, 0.3125f, f4, f8, 1.0f, f12);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        } else {
            float f1 = 0.4375f;
            float f9 = 0.5625f;
            float f5 = 0.0f;
            float f13 = 0.125f;
            gate.a(f1, 0.3125f, f5, f9, 1.0f, f13);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            f5 = 0.875f;
            f13 = 1.0f;
            gate.a(f1, 0.3125f, f5, f9, 1.0f, f13);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        }
        if (!open) {
            if (meta == 0) {
                float f2 = 0.375f;
                float f10 = 0.5f;
                float f6 = 0.4375f;
                float f14 = 0.5625f;
                gate.a(f2, 0.375f, f6, f10, 0.9375f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f2 = 0.5f;
                f10 = 0.625f;
                gate.a(f2, 0.375f, f6, f10, 0.9375f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f2 = 0.625f;
                f10 = 0.875f;
                gate.a(f2, 0.375f, f6, f10, 0.5625f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                gate.a(f2, 0.75f, f6, f10, 0.9375f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f2 = 0.125f;
                f10 = 0.375f;
                gate.a(f2, 0.375f, f6, f10, 0.5625f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                gate.a(f2, 0.75f, f6, f10, 0.9375f, f14);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
            } else {
                float f3 = 0.4375f;
                float f11 = 0.5625f;
                float f7 = 0.375f;
                float f15 = 0.5f;
                gate.a(f3, 0.375f, f7, f11, 0.9375f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f7 = 0.5f;
                f15 = 0.625f;
                gate.a(f3, 0.375f, f7, f11, 0.9375f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f7 = 0.625f;
                f15 = 0.875f;
                gate.a(f3, 0.375f, f7, f11, 0.5625f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                gate.a(f3, 0.75f, f7, f11, 0.9375f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                f7 = 0.125f;
                f15 = 0.375f;
                gate.a(f3, 0.375f, f7, f11, 0.5625f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
                gate.a(f3, 0.75f, f7, f11, 0.9375f, f15);
                RenderTools.renderStandardBlock(render, gate, i, j, k);
            }
        } else if (meta == 1 && !track.isReversed()) {
            gate.a(0.8125f, 0.375f, 0.0f, 0.9375f, 0.9375f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.8125f, 0.375f, 0.875f, 0.9375f, 0.9375f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.5625f, 0.375f, 0.0f, 0.8125f, 0.5625f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.5625f, 0.375f, 0.875f, 0.8125f, 0.5625f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.5625f, 0.75f, 0.0f, 0.8125f, 0.9375f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.5625f, 0.75f, 0.875f, 0.8125f, 0.9375f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        } else if (meta == 1 && track.isReversed()) {
            gate.a(0.0625f, 0.375f, 0.0f, 0.1875f, 0.9375f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.0625f, 0.375f, 0.875f, 0.1875f, 0.9375f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.1875f, 0.375f, 0.0f, 0.4375f, 0.5625f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.1875f, 0.375f, 0.875f, 0.4375f, 0.5625f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.1875f, 0.75f, 0.0f, 0.4375f, 0.9375f, 0.125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.1875f, 0.75f, 0.875f, 0.4375f, 0.9375f, 1.0f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        } else if (meta == 0 && track.isReversed()) {
            gate.a(0.0f, 0.375f, 0.8125f, 0.125f, 0.9375f, 0.9375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.375f, 0.8125f, 1.0f, 0.9375f, 0.9375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.0f, 0.375f, 0.5625f, 0.125f, 0.5625f, 0.8125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.375f, 0.5625f, 1.0f, 0.5625f, 0.8125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.0f, 0.75f, 0.5625f, 0.125f, 0.9375f, 0.8125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.75f, 0.5625f, 1.0f, 0.9375f, 0.8125f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        } else if (meta == 0 && !track.isReversed()) {
            gate.a(0.0f, 0.375f, 0.0625f, 0.125f, 0.9375f, 0.1875f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.375f, 0.0625f, 1.0f, 0.9375f, 0.1875f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.0f, 0.375f, 0.1875f, 0.125f, 0.5625f, 0.4375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.375f, 0.1875f, 1.0f, 0.5625f, 0.4375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.0f, 0.75f, 0.1875f, 0.125f, 0.9375f, 0.4375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
            gate.a(0.875f, 0.75f, 0.1875f, 1.0f, 0.9375f, 0.4375f);
            RenderTools.renderStandardBlock(render, gate, i, j, k);
        }
        gate.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

