/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.client.IItemRenderer;
import railcraft.client.render.ICombinedRenderer;
import railcraft.client.render.RenderTools;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.signals.BlockSignal;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.ItemSignal;
import railcraft.common.blocks.signals.TileBoxBase;

public class RenderSignalBox
implements ICombinedRenderer {
    @Override
    public void renderBlock(bbb renderblocks, ym world, int i, int j, int k, amq block) {
        TileBoxBase tile = (TileBoxBase)world.q(i, j, k);
        EnumSignal structure = tile.getSignalType();
        float pix = 0.0625f;
        boolean eastWest = false;
        boolean northSouth = false;
        if (tile.connectToBoxAt(i - 1, j, k, 5) || tile.connectToBoxAt(i + 1, j, k, 4)) {
            eastWest = true;
        }
        if (tile.connectToBoxAt(i, j, k - 1, 3) || tile.connectToBoxAt(i, j, k + 1, 2)) {
            northSouth = true;
        }
        boolean side2 = tile.connectToBoxAt(i, j, k - 1, 5);
        boolean side3 = tile.connectToBoxAt(i, j, k + 1, 4);
        boolean side4 = tile.connectToBoxAt(i - 1, j, k, 3);
        boolean side5 = tile.connectToBoxAt(i + 1, j, k, 2);
        if (!eastWest && !northSouth) {
            eastWest = true;
        }
        float f = 7.0f * pix;
        float f1 = 9.0f * pix;
        float f2 = 10.0f * pix;
        float f3 = 12.0f * pix;
        float f4 = side4 ? 0.0f : f;
        float f5 = side5 ? 1.0f : f1;
        float f6 = side2 ? 0.0f : f;
        float f7 = side3 ? 1.0f : f1;
        structure.setUseAltTextures(true);
        structure.setUseAltTextureOnSide(0, structure.getSecondaryTexture());
        structure.setUseAltTextureOnSide(1, structure.getSecondaryTexture());
        if (side2) {
            structure.setUseOffsetTextureOnSide(2, 16);
        }
        if (side3) {
            structure.setUseOffsetTextureOnSide(3, 16);
        }
        if (side4) {
            structure.setUseOffsetTextureOnSide(4, 16);
        }
        if (side5) {
            structure.setUseOffsetTextureOnSide(5, 16);
        }
        block.a(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        if (!world.c(i, j + 1, k)) {
            structure.setUseAltTextureOnSide(1, structure.getPrimaryTexture() + 48 - 1);
            block.a(5.0f * pix, 15.0f * pix, 5.0f * pix, 11.0f * pix, 16.0f * pix, 11.0f * pix);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
            block.a(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
            structure.setUseAltTextureOnSide(1, structure.getSecondaryTexture());
        }
        if (tile.getBoxSignalAspect().isBlinkAspect() && !SignalAspect.isBlinkOn()) {
            int offset = 1 + SignalAspect.OFF.getTextureOffset();
            for (int ii = 2; ii < 6; ++ii) {
                if (structure.getBlockTextureFromSide(ii) != structure.getPrimaryTexture()) continue;
                structure.setUseOffsetTextureOnSide(ii, offset);
            }
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        } else {
            int offset = 1 + tile.getBoxSignalAspect().getTextureOffset();
            if (!side2) {
                structure.setUseOffsetTextureOnSide(2, offset);
                RenderTools.renderBlockSideWithBrightness(renderblocks, world, block, i, j, k, 2, 165);
            }
            if (!side3) {
                structure.setUseOffsetTextureOnSide(3, offset);
                RenderTools.renderBlockSideWithBrightness(renderblocks, world, block, i, j, k, 3, 165);
            }
            if (!side4) {
                structure.setUseOffsetTextureOnSide(4, offset);
                RenderTools.renderBlockSideWithBrightness(renderblocks, world, block, i, j, k, 4, 165);
            }
            if (!side5) {
                structure.setUseOffsetTextureOnSide(5, offset);
                RenderTools.renderBlockSideWithBrightness(renderblocks, world, block, i, j, k, 5, 165);
            }
        }
        structure.setAltTextureIndex(structure.getOffsetTexture(48));
        if (eastWest) {
            block.a(f4, f2, f, f5, f3, f1);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        }
        if (northSouth) {
            block.a(f, f2, f6, f1, f3, f7);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        }
        f2 = 5.0f * pix;
        f3 = 7.0f * pix;
        if (eastWest) {
            block.a(f4, f2, f, f5, f3, f1);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        }
        if (northSouth) {
            block.a(f, f2, f6, f1, f3, f7);
            RenderTools.renderStandardBlock(renderblocks, block, i, j, k);
        }
        structure.setUseAltTextures(false);
        block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void renderItem(bbb renderblocks, ur item, IItemRenderer.ItemRenderType renderType) {
        EnumSignal structure = null;
        if (!(item.b() instanceof ItemSignal)) {
            return;
        }
        structure = EnumSignal.fromId(item.j());
        BlockSignal block = (BlockSignal)RailcraftBlocks.getBlockSignal();
        float pix = 0.0625f;
        block.a(2.0f * pix, 0.0f, 2.0f * pix, 14.0f * pix, 15.0f * pix, 14.0f * pix);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, structure.ordinal(), 1.0f);
        structure.setUseAltTextures(true);
        int texture = structure.getPrimaryTexture() + 1;
        int n = structure == EnumSignal.BOX_RECEIVER ? SignalAspect.RED.getTextureOffset() : SignalAspect.GREEN.getTextureOffset();
        structure.setUseAltTextureOnSide(0, structure.getSecondaryTexture());
        structure.setUseAltTextureOnSide(1, structure.getSecondaryTexture());
        structure.setUseAltTextureOnSide(2, texture += n);
        structure.setUseAltTextureOnSide(3, texture);
        structure.setUseAltTextureOnSide(4, texture);
        structure.setUseAltTextureOnSide(5, texture);
        RenderTools.renderBlockOnInventory(renderblocks, (amq)block, structure.ordinal(), 1.0f);
        structure.setUseAltTextures(false);
        block.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }
}

