/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import railcraft.client.gui.GuiBasic;
import railcraft.client.gui.GuiTools;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.signals.TileBoxController;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiBoxController
extends GuiBasic {
    private final TileBoxController tile;
    private SignalAspect defaultAspect;
    private SignalAspect poweredAspect;

    public GuiBoxController(TileBoxController t) {
        super(t.b());
        this.tile = t;
        this.defaultAspect = t.defaultAspect;
        this.poweredAspect = t.poweredAspect;
    }

    public void A_() {
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.xSize) / 2;
        int h = (this.h - this.ySize) / 2;
        this.i.add(new atb(0, w + 10, h + 25, 30, 20, "<"));
        this.i.add(new atb(1, w + 135, h + 25, 30, 20, ">"));
        this.i.add(new atb(2, w + 10, h + 60, 30, 20, "<"));
        this.i.add(new atb(3, w + 135, h + 60, 30, 20, ">"));
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        GuiTools.drawCenteredString(this.l, RailcraftLanguage.translate("gui.box.controller.aspect.default"), 25);
        GuiTools.drawCenteredString(this.l, this.defaultAspect.toString(), 35);
        GuiTools.drawCenteredString(this.l, RailcraftLanguage.translate("gui.box.controller.aspect.redstone"), 60);
        GuiTools.drawCenteredString(this.l, this.poweredAspect.toString(), 70);
    }

    protected void a(atb button) {
        if (this.tile == null) {
            return;
        }
        int normal = this.defaultAspect.ordinal();
        int redstone = this.poweredAspect.ordinal();
        switch (button.f) {
            case 0: {
                --normal;
                break;
            }
            case 1: {
                ++normal;
                break;
            }
            case 2: {
                --redstone;
                break;
            }
            case 3: {
                ++redstone;
            }
        }
        normal = Math.min(normal, SignalAspect.OFF.ordinal());
        normal = Math.max(normal, 0);
        redstone = Math.min(redstone, SignalAspect.OFF.ordinal());
        redstone = Math.max(redstone, 0);
        this.defaultAspect = SignalAspect.values()[normal];
        this.poweredAspect = SignalAspect.values()[redstone];
    }

    public void b() {
        if (Game.isNotHost(this.tile.getWorld())) {
            this.tile.defaultAspect = this.defaultAspect;
            this.tile.poweredAspect = this.poweredAspect;
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }
}

