/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import railcraft.client.gui.GuiBasic;
import railcraft.client.gui.GuiTools;
import railcraft.client.gui.buttons.GuiToggleButton;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.blocks.signals.IAspectActionManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.IGuiReturnHandler;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiAspectAction
extends GuiBasic {
    private final IAspectActionManager tile;
    private final String action;
    private boolean[] aspects = new boolean[SignalAspect.values().length];

    public GuiAspectAction(String action, IAspectActionManager t) {
        super(t.b());
        this.tile = t;
        this.action = action;
        for (SignalAspect aspect : SignalAspect.values()) {
            this.aspects[aspect.ordinal()] = this.tile.doesActionOnAspect(aspect);
        }
    }

    public void A_() {
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.xSize) / 2;
        int h = (this.h - this.ySize) / 2;
        this.i.add(new GuiToggleButton(0, w + 7, h + 35, 50, 20, "Green", this.aspects[SignalAspect.GREEN.ordinal()]));
        this.i.add(new GuiToggleButton(1, w + 12, h + 60, 70, 20, "Blink Yellow", this.aspects[SignalAspect.BLINK_YELLOW.ordinal()]));
        this.i.add(new GuiToggleButton(2, w + 63, h + 35, 50, 20, "Yellow", this.aspects[SignalAspect.YELLOW.ordinal()]));
        this.i.add(new GuiToggleButton(3, w + 94, h + 60, 70, 20, "Blink Red", this.aspects[SignalAspect.BLINK_RED.ordinal()]));
        this.i.add(new GuiToggleButton(4, w + 119, h + 35, 50, 20, "Red", this.aspects[SignalAspect.RED.ordinal()]));
    }

    @Override
    protected void drawExtras(int x, int y, float f) {
        GuiTools.drawCenteredString(this.l, this.action, 20);
    }

    protected void a(atb button) {
        if (this.tile == null) {
            return;
        }
        SignalAspect aspect = SignalAspect.values()[button.f];
        this.aspects[aspect.ordinal()] = !this.aspects[aspect.ordinal()];
        ((GuiToggleButton)button).active = this.aspects[aspect.ordinal()];
    }

    public void b() {
        if (Game.isNotHost(this.tile.getWorld()) && this.tile instanceof IGuiReturnHandler) {
            for (SignalAspect aspect : SignalAspect.values()) {
                this.tile.doActionOnAspect(aspect, this.aspects[aspect.ordinal()]);
            }
            PacketGuiReturn pkt = new PacketGuiReturn((IGuiReturnHandler)((Object)this.tile));
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }
}

