/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.fabrica.block.BlockCustomStairs;
import extrabiomes.module.fabrica.block.BlockCustomWall;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.module.fabrica.block.BlockCustomWoodSlab;
import extrabiomes.module.fabrica.block.BlockRedRockSlab;
import extrabiomes.module.fabrica.block.BlockWoodStairs;
import extrabiomes.module.fabrica.block.FuelHandlerWoodSlabs;
import extrabiomes.module.fabrica.block.ItemRedRockSlab;
import extrabiomes.module.fabrica.block.ItemWoodSlab;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.MultiItemBlock;

public enum BlockManager {
    PLANKS{

        @Override
        protected void create() {
            Stuff.planks = Optional.of((Object)((Object)new BlockCustomWood(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.PLANKS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.planks.get();
            thisBlock.b("extrabiomes.planks");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            for (BlockCustomWood.BlockType type : BlockCustomWood.BlockType.values()) {
                FacadeHelper.addBuildcraftFacade(thisBlock.cm, type.metadata());
            }
            proxy.registerOre("plankWood", new ur(thisBlock, 1, -1));
            Extrabiomes.postInitEvent(new BlockActiveEvent.PlankActiveEvent(thisBlock));
        }
    }
    ,
    WOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWood = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.slabWood.get();
            thisBlock.b("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock.cm));
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEWOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWoodDouble = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.slabWoodDouble.get();
            thisBlock.b("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemWoodSlab.setSlabs((akl)Stuff.slabWood.get(), (akl)Stuff.slabWoodDouble.get());
            proxy.registerBlock((amq)Stuff.slabWood.get(), ItemWoodSlab.class);
            proxy.registerBlock(thisBlock, ItemWoodSlab.class);
            proxy.registerOre("slabWood", new ur((amq)Stuff.slabWood.get(), 1, -1));
            new ur((amq)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.FIR.metadata());
            new ur((amq)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.REDWOOD.metadata());
            new ur((amq)Stuff.slabWood.get(), 1, BlockCustomWoodSlab.BlockType.ACACIA.metadata());
        }
    }
    ,
    REDWOODSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedwood = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (amq)Stuff.planks.get(), BlockCustomWood.BlockType.REDWOOD.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.stairsRedwood.get();
            thisBlock.b("extrabiomes.stairs.redwood");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedwoodStairsActiveEvent(thisBlock));
        }
    }
    ,
    FIRSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsFir = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (amq)Stuff.planks.get(), BlockCustomWood.BlockType.FIR.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.stairsFir.get();
            thisBlock.b("extrabiomes.stairs.fir");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.FirStairsActiveEvent(thisBlock));
        }
    }
    ,
    ACACIASTAIRS{

        @Override
        protected void create() {
            Stuff.stairsAcacia = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (amq)Stuff.planks.get(), BlockCustomWood.BlockType.ACACIA.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIASTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.stairsAcacia.get();
            thisBlock.b("extrabiomes.stairs.acacia");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock);
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AcaciaStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRock = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.slabRedRock.get();
            thisBlock.b("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEREDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRockDouble = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEREDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.slabRedRockDouble.get();
            thisBlock.b("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            ItemRedRockSlab.setSlabs((akl)Stuff.slabRedRock.get(), (akl)Stuff.slabRedRockDouble.get());
            proxy.registerBlock((amq)Stuff.slabRedRock.get(), ItemRedRockSlab.class);
            proxy.registerBlock(thisBlock, ItemRedRockSlab.class);
        }
    }
    ,
    REDCOBBLESTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedCobble = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), amq.p[Element.RED_COBBLE.get().c], Element.RED_COBBLE.get().j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDCOBBLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.stairsRedCobble.get();
            thisBlock.b("extrabiomes.stairs.redcobble");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedCobbleStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKBRICKSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedRockBrick = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), amq.p[Element.RED_ROCK_BRICK.get().c], Element.RED_ROCK_BRICK.get().j())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKBRICKSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.stairsRedRockBrick.get();
            thisBlock.b("extrabiomes.stairs.redrockbrick");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockBrickStairsActiveEvent(thisBlock));
        }
    }
    ,
    WALL{

        @Override
        protected void create() {
            Stuff.wall = Optional.of((Object)((Object)new BlockCustomWall(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            amq thisBlock = (amq)Stuff.wall.get();
            thisBlock.b("extrabiomes.wall");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class);
            Extrabiomes.postInitEvent(new BlockActiveEvent.WallActiveEvent(thisBlock));
        }
    };

    private boolean blockCreated = false;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private BlockManager() {
    }

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (block.getSettings().getID() <= 0) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    /* synthetic */ BlockManager(1 x0) {
        this((String)x0, (int)x1);
        void x1;
    }
}

