/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.json;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.converter.internal.JsonUtils;
import net.sf.practicalxml.converter.internal.TypeUtils;
import net.sf.practicalxml.converter.json.Xml2JsonOptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2JsonConverter {
    private static Set<String> _unquotedXsd = new HashSet<String>();
    private EnumSet<Xml2JsonOptions> _options = EnumSet.noneOf(Xml2JsonOptions.class);

    public Xml2JsonConverter(Xml2JsonOptions ... options) {
        for (Xml2JsonOptions option : options) {
            this._options.add(option);
        }
    }

    public String convert(Element elem) {
        return this.convert(elem, new StringBuilder(256)).toString();
    }

    public StringBuilder convert(Element elem, StringBuilder buf) {
        if (this._options.contains((Object)Xml2JsonOptions.WRAP_WITH_PARENS)) {
            buf.append("(");
            this.append(buf, elem);
            buf.append(")");
        } else {
            this.append(buf, elem);
        }
        return buf;
    }

    private StringBuilder append(StringBuilder buf, Element elem) {
        if (this.isSimple(elem)) {
            if (buf.length() == 0) {
                buf.append("{}");
            } else {
                this.appendText(buf, elem);
            }
        } else {
            buf.append("{");
            this.appendAttributes(buf, elem);
            this.appendChildren(buf, elem);
            buf.append("}");
        }
        return buf;
    }

    private void appendText(StringBuilder buf, Element elem) {
        String text = DomUtil.getText(elem);
        String type = TypeUtils.getTypeValue(elem);
        String quote = "\"";
        if (this._options.contains((Object)Xml2JsonOptions.USE_XSI_TYPE) && _unquotedXsd.contains(type)) {
            quote = "";
        }
        buf.append(quote).append(JsonUtils.escape(text)).append(quote);
    }

    private void appendAttributes(StringBuilder buf, Element elem) {
        if (!this._options.contains((Object)Xml2JsonOptions.CONVERT_ATTRIBUTES) && !this._options.contains((Object)Xml2JsonOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE)) {
            return;
        }
        NamedNodeMap attrs = elem.getAttributes();
        if (attrs == null) {
            return;
        }
        for (int ii2 = 0; ii2 < attrs.getLength(); ++ii2) {
            Attr attr = (Attr)attrs.item(ii2);
            if (!this.isConvertableAttribute(elem, attr)) continue;
            this.appendCommaIfNeeded(buf);
            this.appendFieldName(buf, DomUtil.getLocalName(attr));
            buf.append("\"").append(JsonUtils.escape(attr.getValue())).append("\"");
        }
    }

    private void appendChildren(StringBuilder buf, Element elem) {
        ArrayList<String> names = new ArrayList<String>();
        HashMap<String, List<Element>> arrays = new HashMap<String, List<Element>>();
        HashMap<String, Element> nonArrays = new HashMap<String, Element>();
        this.categorizeChildren(elem, names, arrays, nonArrays);
        Iterator itx = names.iterator();
        while (itx.hasNext()) {
            this.appendCommaIfNeeded(buf);
            String name = (String)itx.next();
            this.appendFieldName(buf, name);
            if (arrays.containsKey(name)) {
                this.appendArray(buf, (List)arrays.get(name));
                continue;
            }
            this.append(buf, (Element)nonArrays.get(name));
        }
    }

    private void appendArray(StringBuilder buf, List<Element> values) {
        buf.append("[");
        Iterator<Element> itx = values.iterator();
        while (itx.hasNext()) {
            Element child = itx.next();
            this.append(buf, child);
            if (!itx.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
    }

    private void appendFieldName(StringBuilder buf, String name) {
        if (this._options.contains((Object)Xml2JsonOptions.UNQUOTED_FIELD_NAMES)) {
            buf.append(name);
        } else {
            buf.append('\"').append(name).append('\"');
        }
        buf.append(": ");
    }

    private void appendCommaIfNeeded(StringBuilder buf) {
        for (int ii2 = buf.length() - 1; ii2 >= 0; --ii2) {
            char c2 = buf.charAt(ii2);
            if (c2 == '{') {
                return;
            }
            if (c2 == ' ') continue;
            buf.append(", ");
            return;
        }
    }

    private void categorizeChildren(Element elem, List<String> names, Map<String, List<Element>> arrays, Map<String, Element> nonArrays) {
        for (Element child : DomUtil.getChildren(elem)) {
            List<Element> array;
            String name = DomUtil.getLocalName(child);
            if (!arrays.containsKey(name) && !nonArrays.containsKey(name)) {
                names.add(name);
            }
            if (arrays.containsKey(name)) {
                this.getArray(name, arrays).add(child);
                continue;
            }
            if (nonArrays.containsKey(name)) {
                array = this.getArray(name, arrays);
                Element prev = nonArrays.remove(name);
                array.add(prev);
                array.add(child);
                continue;
            }
            if (this.isArrayParent(child)) {
                array = this.getArray(name, arrays);
                for (Element grandchild : DomUtil.getChildren(child)) {
                    array.add(grandchild);
                }
                continue;
            }
            nonArrays.put(name, child);
        }
    }

    private List<Element> getArray(String name, Map<String, List<Element>> arrays) {
        List<Element> array = arrays.get(name);
        if (array == null) {
            array = new ArrayList<Element>();
            arrays.put(name, array);
        }
        return array;
    }

    private boolean isSimple(Element elem) {
        NamedNodeMap attrs;
        if (this._options.contains((Object)Xml2JsonOptions.CONVERT_ATTRIBUTES) && (attrs = elem.getAttributes()) != null && attrs.getLength() > 0) {
            return false;
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return false;
        }
        return true;
    }

    private boolean isArrayParent(Element elem) {
        if (!this._options.contains((Object)Xml2JsonOptions.USE_XSI_TYPE)) {
            return false;
        }
        Class<?> klass = TypeUtils.getType(elem, false);
        if (klass == null) {
            return false;
        }
        if (klass.isArray()) {
            return true;
        }
        if (List.class.isAssignableFrom(klass)) {
            return true;
        }
        return Set.class.isAssignableFrom(klass);
    }

    private boolean isConvertableAttribute(Element elem, Attr attr) {
        String attrNS;
        String elemNS = elem.getNamespaceURI() != null ? elem.getNamespaceURI() : "";
        String string = attrNS = attr.getNamespaceURI() != null ? attr.getNamespaceURI() : "";
        if (this._options.contains((Object)Xml2JsonOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE) && !elemNS.equals(attrNS)) {
            return false;
        }
        return !attrNS.equals("http://www.w3.org/2001/XMLSchema-instance") && !attrNS.equals("http://practicalxml.sourceforge.net/Converter");
    }

    static {
        _unquotedXsd.add("xsd:boolean");
        _unquotedXsd.add("xsd:byte");
        _unquotedXsd.add("xsd:decimal");
        _unquotedXsd.add("xsd:double");
        _unquotedXsd.add("xsd:float");
        _unquotedXsd.add("xsd:int");
        _unquotedXsd.add("xsd:integer");
        _unquotedXsd.add("xsd:long");
        _unquotedXsd.add("xsd:negativeInteger");
        _unquotedXsd.add("xsd:nonNegativeInteger");
        _unquotedXsd.add("xsd:nonPositiveInteger");
        _unquotedXsd.add("xsd:positiveInteger");
        _unquotedXsd.add("xsd:short");
        _unquotedXsd.add("xsd:unsignedByte");
        _unquotedXsd.add("xsd:unsignedInt");
        _unquotedXsd.add("xsd:unsignedLong");
        _unquotedXsd.add("xsd:unsignedShort");
    }
}

