/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.internal;

import net.sf.kdgcommons.lang.StringUtil;

public class JsonUtils {
    public static String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(src.length() + 20);
        block8: for (int ii2 = 0; ii2 < src.length(); ++ii2) {
            char c2 = src.charAt(ii2);
            switch (c2) {
                case '\"': 
                case '/': 
                case '\\': {
                    buf.append('\\').append(c2);
                    continue block8;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block8;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block8;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block8;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block8;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block8;
                }
                default: {
                    if (c2 >= ' ' && c2 <= '\u007f') {
                        buf.append(c2);
                        continue block8;
                    }
                    buf.append(JsonUtils.escapeUnicode(c2));
                }
            }
        }
        return buf.toString();
    }

    public static String unescape(String src) {
        if (src == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(src.length());
        int ii2 = 0;
        while (ii2 < src.length()) {
            char c2;
            if ((c2 = src.charAt(ii2++)) == '\\') {
                if (ii2 == src.length()) {
                    throw new IllegalArgumentException("escape extends past end of string");
                }
                c2 = src.charAt(ii2++);
                switch (c2) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        break;
                    }
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        c2 = JsonUtils.unescapeUnicode(src, ii2);
                        ii2 += 4;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid escape character: " + c2);
                    }
                }
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    private static char unescapeUnicode(String src, int idx) {
        if (idx + 4 > src.length()) {
            throw new IllegalArgumentException("unicode escape extends past end of string");
        }
        int value = 0;
        for (int ii2 = 0; ii2 < 4; ++ii2) {
            int digit = StringUtil.parseDigit(src.charAt(idx + ii2), 16);
            if (digit < 0) {
                throw new IllegalArgumentException("invalid unicode escape: " + src.substring(idx, idx + 4));
            }
            value = value * 16 + digit;
        }
        return (char)value;
    }

    private static String escapeUnicode(char c2) {
        char[] buf = new char[]{'\\', 'u', '0', '0', '0', '0'};
        int value = c2 & 0xFFFF;
        for (int ii2 = 5; ii2 > 1; --ii2) {
            int digit = value % 16;
            value /= 16;
            buf[ii2] = Character.forDigit(digit, 16);
        }
        return new String(buf);
    }
}

