/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml.converter.bean;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.kdgcommons.lang.StringUtil;
import net.sf.practicalxml.DomUtil;
import net.sf.practicalxml.converter.ConversionException;
import net.sf.practicalxml.converter.bean.IntrospectionCache;
import net.sf.practicalxml.converter.bean.Xml2BeanOptions;
import net.sf.practicalxml.converter.internal.ConversionUtils;
import net.sf.practicalxml.converter.internal.JavaStringConversions;
import net.sf.practicalxml.converter.internal.TypeUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2BeanConverter {
    private EnumSet<Xml2BeanOptions> _options = EnumSet.noneOf(Xml2BeanOptions.class);
    private IntrospectionCache _introspections;
    private JavaStringConversions _converter;
    private EnumParser _enumParser;

    public Xml2BeanConverter(Xml2BeanOptions ... options) {
        for (Xml2BeanOptions option : options) {
            this._options.add(option);
        }
        this._introspections = new IntrospectionCache(this._options.contains((Object)Xml2BeanOptions.CACHE_INTROSPECTIONS));
        this._converter = new JavaStringConversions(this._options.contains((Object)Xml2BeanOptions.EXPECT_XSD_FORMAT));
    }

    public <T> T convert(Element elem, Class<T> klass) {
        return klass.cast(this.convertWithoutCast(elem, klass));
    }

    public Object convertWithoutCast(Element elem, Class<?> klass) {
        this.validateXsiType(elem, klass);
        if (this.isAllowableNull(elem)) {
            return null;
        }
        Object obj = this.tryConvertSimple(elem, klass);
        if (obj == null) {
            obj = this.tryConvertAsEnum(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsArray(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsSimpleCollection(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsMap(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsCalendar(elem, klass);
        }
        if (obj == null) {
            obj = this.tryConvertAsBean(elem, klass);
        }
        return obj;
    }

    private boolean isAllowableNull(Element elem) {
        String text = this.getText(elem, false);
        if (text != null || this.hasElementChildren(elem)) {
            return false;
        }
        for (Attr attr : DomUtil.getAttributes(elem)) {
            if (!this.isConvertableAttribute(elem, attr)) continue;
            return false;
        }
        if (this._options.contains((Object)Xml2BeanOptions.REQUIRE_XSI_NIL) && !ConversionUtils.getXsiNil(elem)) {
            throw new ConversionException("missing/false xsi:nil", elem);
        }
        return true;
    }

    private Object tryConvertSimple(Element elem, Class<?> klass) {
        if (!this._converter.isConvertableToString(klass)) {
            return null;
        }
        return this._converter.parse(this.getText(elem, true), klass);
    }

    private Object tryConvertAsEnum(Element elem, Class<?> klass) {
        if (!Enum.class.isAssignableFrom(klass)) {
            return null;
        }
        if (this._enumParser == null) {
            this._enumParser = new EnumParser();
        }
        return this._enumParser.parse(elem, klass);
    }

    private Object tryConvertAsArray(Element elem, Class<?> klass) {
        Class<?> childKlass = klass.getComponentType();
        if (childKlass == null) {
            return null;
        }
        List<Element> children = DomUtil.getChildren(elem);
        Object result = Array.newInstance(childKlass, children.size());
        int idx = 0;
        for (Element child : children) {
            Array.set(result, idx++, this.convertWithoutCast(child, childKlass));
        }
        return result;
    }

    private Object tryConvertAsSimpleCollection(Element elem, Class<?> klass) {
        Collection<Object> result = this.instantiateCollection(klass);
        if (result == null) {
            return null;
        }
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            Class<?> childClass = this.getCollectionElementClass(child);
            result.add(this.convertWithoutCast(child, childClass));
        }
        return result;
    }

    private Object tryConvertAsMap(Element elem, Class<?> klass) {
        Map<Object, Object> result = this.instantiateMap(klass);
        if (result == null) {
            return null;
        }
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            String key = ConversionUtils.getAttribute(child, "key");
            if (StringUtil.isEmpty(key)) {
                key = DomUtil.getLocalName(child);
            }
            Class<?> childClass = this.getCollectionElementClass(child);
            result.put(key, this.convertWithoutCast(child, childClass));
        }
        return result;
    }

    private Object tryConvertAsCalendar(Element elem, Class<?> klass) {
        if (!Calendar.class.isAssignableFrom(klass)) {
            return null;
        }
        Date date = null;
        TimeZone zone = null;
        int firstDayOfWeek = -1;
        int minDaysInFirstWeek = -1;
        for (Element child : DomUtil.getChildren(elem)) {
            String childName = DomUtil.getLocalName(child);
            String childText = this.getText(child, true);
            if (childName.equals("date")) {
                date = (Date)this._converter.parse(childText, Date.class);
                continue;
            }
            if (childName.equals("timezone")) {
                zone = (TimeZone)this._converter.parse(childText, TimeZone.class);
                continue;
            }
            if (childName.equals("firstDayOfWeek")) {
                firstDayOfWeek = Integer.parseInt(childText);
                continue;
            }
            if (!childName.equals("minimumDaysInFirstWeek")) continue;
            minDaysInFirstWeek = Integer.parseInt(childText);
        }
        Calendar cal = Calendar.getInstance(zone);
        cal.setTime(date);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        cal.setMinimalDaysInFirstWeek(minDaysInFirstWeek);
        return cal;
    }

    private Object tryConvertAsBean(Element elem, Class<?> klass) {
        Object bean = this.instantiateBean(elem, klass);
        this.convertAttributes(elem, bean);
        this.convertChildren(elem, bean);
        return bean;
    }

    private String getText(Element elem, boolean validateTextOnly) {
        if (validateTextOnly && this.hasElementChildren(elem)) {
            throw new ConversionException("unexpected child elements", elem);
        }
        String text = DomUtil.getText(elem);
        if (StringUtil.isBlank(text) && this._options.contains((Object)Xml2BeanOptions.EMPTY_IS_NULL)) {
            text = null;
        }
        return text;
    }

    private void validateXsiType(Element elem, Class<?> klass) {
        if (this._options.contains((Object)Xml2BeanOptions.REQUIRE_TYPE)) {
            TypeUtils.validateType(elem, klass);
        }
    }

    private Class<?> getCollectionElementClass(Element child) {
        Class<?> childClass = TypeUtils.getType(child, false);
        return childClass != null ? childClass : String.class;
    }

    private boolean hasElementChildren(Element elem) {
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return true;
        }
        return false;
    }

    private boolean isConvertableAttribute(Element elem, Attr attr) {
        String attrNS;
        if (!this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES) && !this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE)) {
            return false;
        }
        String elemNS = elem.getNamespaceURI() != null ? elem.getNamespaceURI() : "";
        String string = attrNS = attr.getNamespaceURI() != null ? attr.getNamespaceURI() : "";
        if (this._options.contains((Object)Xml2BeanOptions.CONVERT_ATTRIBUTES_MATCH_NAMESPACE) && !elemNS.equals(attrNS)) {
            return false;
        }
        return !attrNS.equals("http://www.w3.org/2001/XMLSchema-instance") && !attrNS.equals("http://practicalxml.sourceforge.net/Converter");
    }

    private void convertAttributes(Element elem, Object bean) {
        Class<?> klass = bean.getClass();
        List<Attr> attrs = DomUtil.getAttributes(elem);
        for (Attr attr : attrs) {
            Object attrValue;
            Class<?> attrClass;
            Method setter;
            if (!this.isConvertableAttribute(elem, attr) || (setter = this.getSetterMethod(klass, elem, DomUtil.getLocalName(attr))) == null || !this._converter.isConvertableToString(attrClass = setter.getParameterTypes()[0]) || (attrValue = this._converter.parse(attr.getValue(), attrClass)) == null) continue;
            this.invokeSetter(elem, bean, setter, attrValue);
        }
    }

    private void convertChildren(Element elem, Object bean) {
        Class<?> klass = bean.getClass();
        List<Element> children = DomUtil.getChildren(elem);
        for (Element child : children) {
            Method setter = this.getSetterMethod(klass, child, DomUtil.getLocalName(child));
            if (setter == null) continue;
            Class<?> childClass = setter.getParameterTypes()[0];
            Object childValue = this.convertWithoutCast(child, childClass);
            this.invokeSetter(elem, bean, setter, childValue);
        }
    }

    private Method getSetterMethod(Class<?> beanKlass, Element elem, String propName) {
        Method setter = this._introspections.lookup(beanKlass).setter(propName);
        if (setter == null && !this._options.contains((Object)Xml2BeanOptions.IGNORE_MISSING_PROPERTIES)) {
            throw new ConversionException("can't find property setter: " + propName, elem);
        }
        return setter;
    }

    private Collection<Object> instantiateCollection(Class<?> klass) {
        if (SortedSet.class.isAssignableFrom(klass)) {
            return new TreeSet<Object>();
        }
        if (Set.class.isAssignableFrom(klass)) {
            return new HashSet<Object>();
        }
        if (List.class.isAssignableFrom(klass)) {
            return new ArrayList<Object>();
        }
        if (Collection.class.isAssignableFrom(klass)) {
            return new ArrayList<Object>();
        }
        return null;
    }

    private Map<Object, Object> instantiateMap(Class<?> klass) {
        if (SortedMap.class.isAssignableFrom(klass)) {
            return new TreeMap<Object, Object>();
        }
        if (Map.class.isAssignableFrom(klass)) {
            return new HashMap<Object, Object>();
        }
        return null;
    }

    private Object instantiateBean(Element elem, Class<?> klass) {
        try {
            return klass.newInstance();
        }
        catch (Exception ee2) {
            throw new ConversionException("unable to instantiate bean", elem, (Throwable)ee2);
        }
    }

    private void invokeSetter(Element elem, Object bean, Method setter, Object value) {
        try {
            setter.invoke(bean, value);
        }
        catch (Exception ee2) {
            throw new ConversionException("unable to invoke setter: " + setter.getName(), elem, (Throwable)ee2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumParser {
        private Method _method;

        public EnumParser() {
            try {
                this._method = Enum.class.getDeclaredMethod("valueOf", Class.class, String.class);
            }
            catch (Exception ee2) {
                throw new ConversionException("unable to find Enum.valueOf() method -- should never happen!", ee2);
            }
        }

        public Object parse(Element elem, Class<?> klass) {
            String value = DomUtil.getText(elem);
            try {
                return this._method.invoke(null, klass, value);
            }
            catch (InvocationTargetException ee2) {
                throw new ConversionException("unable to parse enum: " + value, elem, (Throwable)ee2);
            }
            catch (IllegalAccessException ee3) {
                throw new ConversionException("unable to invoke valueOf() for alleged enum: " + klass.getName(), ee3);
            }
        }
    }
}

