/*
 * Decompiled with CFR 0.152.
 */
package net.sf.practicalxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import net.sf.kdgcommons.io.IOUtil;
import net.sf.practicalxml.XmlException;
import net.sf.practicalxml.util.ExceptionErrorHandler;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUtil {
    public static Document parse(InputSource source, ErrorHandler errHandler) {
        DocumentBuilder db2 = ParseUtil.newNVDocumentBuilder();
        if (errHandler != null) {
            db2.setErrorHandler(errHandler);
        }
        try {
            return db2.parse(source);
        }
        catch (IOException e2) {
            throw new XmlException("unable to parse", e2);
        }
        catch (SAXException e3) {
            throw new XmlException("unable to parse", e3);
        }
    }

    public static Document parse(InputSource source) {
        return ParseUtil.parse(source, new ExceptionErrorHandler());
    }

    public static Document parse(String xml) {
        return ParseUtil.parse(new InputSource(new StringReader(xml)));
    }

    public static Document parse(File file) {
        Document document;
        FileInputStream in2 = null;
        try {
            in2 = new FileInputStream(file);
            document = ParseUtil.parse(new InputSource(in2));
        }
        catch (IOException ex2) {
            try {
                throw new XmlException("unable to parse: " + file, ex2);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in2);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(in2);
        return document;
    }

    public static Document validatingParse(InputSource source, EntityResolver resolver, ErrorHandler errHandler) {
        DocumentBuilder db2 = ParseUtil.newDTDDocumentBuilder();
        if (resolver != null) {
            db2.setEntityResolver(resolver);
        }
        if (errHandler != null) {
            db2.setErrorHandler(errHandler);
        }
        try {
            return db2.parse(source);
        }
        catch (IOException e2) {
            throw new XmlException("unable to parse", e2);
        }
        catch (SAXException e3) {
            throw new XmlException("unable to parse", e3);
        }
    }

    public static Document validatingParse(InputSource source, ErrorHandler errHandler) {
        return ParseUtil.validatingParse(source, (EntityResolver)null, errHandler);
    }

    public static Document validatingParse(InputSource source, Schema schema, ErrorHandler errHandler) {
        DocumentBuilder db2 = ParseUtil.newXSDDocumentBuilder(schema);
        if (errHandler != null) {
            db2.setErrorHandler(errHandler);
        }
        try {
            return db2.parse(source);
        }
        catch (IOException e2) {
            throw new XmlException("unable to parse", e2);
        }
        catch (SAXException e3) {
            throw new XmlException("unable to parse", e3);
        }
    }

    public static Document parseFromClasspath(String resourcePath) {
        return ParseUtil.parseFromClasspath(resourcePath, ParseUtil.class);
    }

    public static Document parseFromClasspath(String resourcePath, Class<?> klass) {
        return ParseUtil.parseFromClasspath(resourcePath, klass, new ExceptionErrorHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFromClasspath(String resourcePath, Class<?> klass, ErrorHandler errorHandler) {
        Document document;
        InputStream in2 = null;
        try {
            ClassLoader cl2 = klass.getClassLoader();
            in2 = cl2.getResourceAsStream(resourcePath);
            document = ParseUtil.parse(new InputSource(in2), errorHandler);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in2);
            throw throwable;
        }
        IOUtil.closeQuietly(in2);
        return document;
    }

    private static synchronized DocumentBuilder newNVDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new XmlException("unable to confiure parser", e2);
        }
    }

    private static synchronized DocumentBuilder newDTDDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new XmlException("unable to confiure parser", e2);
        }
    }

    private static synchronized DocumentBuilder newXSDDocumentBuilder(Schema schema) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setValidating(false);
        dbf.setSchema(schema);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new XmlException("unable to configure parser", e2);
        }
    }
}

