/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.util;

import java.io.PrintWriter;
import java.util.Iterator;
import net.sf.kdgcommons.lang.StringBuilderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HexDump {
    private int _bytesPerLine;
    private boolean _showOffset;
    private int _offset;
    private int _offsetWidth;
    private int _spacesAfterOffset;
    private boolean _showChars;
    private int _spacesBeforeChars;
    private boolean _replaceNonAscii;
    private char _replacement;

    public HexDump(int bytesPerLine, boolean showOffset, int offsetWidth, int spacesAfterOffset, boolean showChars, int spacesBeforeChars, boolean replaceNonAscii, char replacement) {
        this._bytesPerLine = bytesPerLine;
        this._showOffset = showOffset;
        this._offset = 0;
        this._offsetWidth = offsetWidth;
        this._spacesAfterOffset = spacesAfterOffset;
        this._showChars = showChars;
        this._spacesBeforeChars = spacesBeforeChars;
        this._replaceNonAscii = replaceNonAscii;
        this._replacement = replacement;
    }

    public HexDump() {
        this(16, true, 8, 2, true, 4, true, ' ');
    }

    public void setOffset(int value) {
        this._offset = value;
    }

    public Iterator<String> iterator(byte[] buf) {
        return this.iterator(buf, 0, buf.length);
    }

    public Iterator<String> iterator(byte[] buf, int off, int len) {
        return new Dumper(buf, off, len);
    }

    public String stringValue(byte[] buf) {
        return this.stringValue(buf, 0, buf.length);
    }

    public String stringValue(byte[] buf, int off, int len) {
        int capacity = (len / this._bytesPerLine + 1) * (1 + this._offsetWidth + this._spacesAfterOffset + 4 * this._bytesPerLine);
        StringBuilder result = new StringBuilder(capacity);
        Iterator<String> itx = this.iterator(buf, off, len);
        while (itx.hasNext()) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(itx.next());
        }
        return result.toString();
    }

    public void write(PrintWriter out, byte[] buf) {
        this.write(out, buf, 0, buf.length);
    }

    public void write(PrintWriter out, byte[] buf, int off, int len) {
        Iterator<String> itx = this.iterator(buf, off, len);
        while (itx.hasNext()) {
            out.println(itx.next());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Dumper
    implements Iterator<String> {
        private byte[] _buf;
        private int _off;
        private int _len;
        private int _lenThisTime;

        public Dumper(byte[] buf, int off, int len) {
            this._buf = buf;
            this._off = off;
            this._len = len;
        }

        @Override
        public boolean hasNext() {
            return this._len > 0;
        }

        @Override
        public String next() {
            StringBuilder buf = new StringBuilder();
            if (HexDump.this._showOffset) {
                this.appendOffset(buf);
            }
            this.appendBytes(buf);
            if (HexDump.this._showChars) {
                this.appendChars(buf);
            }
            this.updateOffsets();
            return buf.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("this iterator isn't backed by a collection");
        }

        private void appendOffset(StringBuilder buf) {
            StringBuilderUtil.appendHex(buf, HexDump.this._offset, HexDump.this._offsetWidth);
            StringBuilderUtil.appendRepeat(buf, ' ', HexDump.this._spacesAfterOffset);
        }

        private void appendBytes(StringBuilder buf) {
            this._lenThisTime = Math.min(HexDump.this._bytesPerLine, this._len);
            for (int ii2 = 0; ii2 < this._lenThisTime; ++ii2) {
                if (ii2 > 0) {
                    buf.append(' ');
                }
                StringBuilderUtil.appendHex(buf, this._buf[this._off + ii2], 2);
            }
        }

        private void appendChars(StringBuilder buf) {
            int spaceThisTime = (HexDump.this._bytesPerLine - this._lenThisTime) * 3 + HexDump.this._spacesBeforeChars;
            StringBuilderUtil.appendRepeat(buf, ' ', spaceThisTime);
            for (int ii2 = 0; ii2 < this._lenThisTime; ++ii2) {
                byte b2 = this._buf[this._off + ii2];
                if (HexDump.this._replaceNonAscii && (b2 < 32 || b2 > 126)) {
                    buf.append(HexDump.this._replacement);
                    continue;
                }
                buf.append((char)(b2 & 0xFF));
            }
        }

        private void updateOffsets() {
            HexDump.this._offset += this._lenThisTime;
            this._off += this._lenThisTime;
            this._len -= this._lenThisTime;
        }
    }
}

