/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.test;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMock
implements InvocationHandler {
    private ArrayList<String> _calls = new ArrayList();
    private ArrayList<Object[]> _args = new ArrayList();

    public <T> T getInstance(Class<T> classToMock) {
        return classToMock.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{classToMock}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this._calls.add(method.getName());
        if (args == null) {
            args = new Object[]{};
        }
        this._args.add(args);
        return null;
    }

    public void assertCallCount(int expected) {
        Assert.assertEquals((String)"call count", (int)expected, (int)this._calls.size());
    }

    public void assertCall(int callNum, String methodName, Object ... args) {
        Assert.assertEquals((String)"incorrect method", (String)methodName, (String)this._calls.get(callNum));
        Assert.assertEquals((String)"argument count", (int)args.length, (int)this._args.get(callNum).length);
        for (int ii2 = 0; ii2 < args.length; ++ii2) {
            Assert.assertEquals((String)("argument " + ii2), (Object)args[ii2], (Object)this._args.get(callNum)[ii2]);
        }
    }
}

