/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.lang;

public class StringBuilderUtil {
    private static final char[] NIBBLES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static StringBuilder appendRepeat(StringBuilder buf, char c2, int count) {
        buf.ensureCapacity(buf.length() + count);
        for (int ii2 = 0; ii2 < count; ++ii2) {
            buf.append(c2);
        }
        return buf;
    }

    public static StringBuilder appendHex(StringBuilder buf, int value, int width) {
        StringBuilderUtil.appendRepeat(buf, '0', width);
        int offset = buf.length();
        for (int ii2 = 1; ii2 <= width; ++ii2) {
            int nibble = value & 0xF;
            buf.setCharAt(offset - ii2, NIBBLES[nibble]);
            value >>>= 4;
        }
        return buf;
    }

    public static char lastChar(StringBuilder buf) {
        int index = buf != null ? buf.length() - 1 : -1;
        return index < 0 ? (char)'\u0000' : buf.charAt(index);
    }
}

