/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static Method[] getAllMethods(Class<?> klass) {
        if (klass == null) {
            return new Method[0];
        }
        Method[] myMethods = klass.getDeclaredMethods();
        Method[] parentMethods = ClassUtil.getAllMethods(klass.getSuperclass());
        ArrayList<Method> combined = new ArrayList<Method>(myMethods.length + parentMethods.length);
        combined.addAll(Arrays.asList(myMethods));
        for (Method method : parentMethods) {
            if (ClassUtil.isOverridden(method, myMethods)) continue;
            combined.add(method);
        }
        return combined.toArray(new Method[combined.size()]);
    }

    public static Method[] getAnnotatedMethods(Class<?> klass, Class<? extends Annotation> annotationKlass) {
        Method[] methods = ClassUtil.getAllMethods(klass);
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.getAnnotation(annotationKlass) == null) continue;
            result.add(method);
        }
        return result.toArray(new Method[result.size()]);
    }

    public static boolean isOverridden(Method method, Method[] methods) {
        for (Method override : methods) {
            if (!override.getName().equals(method.getName()) || !Arrays.equals(override.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

