/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private InputStream _base;
    private OutputStream _tee;

    public TeeInputStream(InputStream base, OutputStream tee) {
        this._base = base;
        this._tee = tee;
    }

    public int available() throws IOException {
        return this._base.available();
    }

    public void close() throws IOException {
        this._base.close();
    }

    public int read() throws IOException {
        int b2 = this._base.read();
        if (b2 >= 0) {
            this._tee.write(b2);
        }
        return b2;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int count = this._base.read(b2, off, len);
        if (count > 0) {
            this._tee.write(b2, off, count);
        }
        return count;
    }

    public int read(byte[] b2) throws IOException {
        int count = this._base.read(b2);
        if (count > 0) {
            this._tee.write(b2, 0, count);
        }
        return count;
    }

    public boolean markSupported() {
        return this._base.markSupported();
    }

    public synchronized void mark(int readlimit) {
        this._base.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this._base.reset();
    }

    public long skip(long n2) throws IOException {
        return this._base.skip(n2);
    }
}

