/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.io;

import java.io.IOException;
import java.io.InputStream;

public abstract class GeneratedInputStream
extends InputStream {
    private byte[] _buf;
    private int _off;
    private boolean _isClosed;

    public int available() throws IOException {
        return this._buf == null ? 0 : this._buf.length - this._off;
    }

    public void close() throws IOException {
        this._isClosed = true;
    }

    public synchronized void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public int read() throws IOException {
        if (this.isAvailable()) {
            return this._buf[this._off++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int bytesRead = 0;
        while (len > 0 && this.isAvailable()) {
            int bytesToCopy = Math.min(this._buf.length - this._off, len - bytesRead);
            System.arraycopy(this._buf, this._off, b2, off, bytesToCopy);
            bytesRead += bytesToCopy;
            off += bytesToCopy;
            len -= bytesToCopy;
            this._off += bytesToCopy;
        }
        return bytesRead;
    }

    public int read(byte[] b2) throws IOException {
        return this.read(b2, 0, b2.length);
    }

    public long skip(long n2) throws IOException {
        long bytesSkipped = 0L;
        byte[] sink = new byte[1024];
        while (n2 > 0L && this.isAvailable()) {
            int bytesRead = this.read(sink, 0, (int)Math.min((long)sink.length, n2));
            n2 -= (long)bytesRead;
            bytesSkipped += (long)bytesRead;
        }
        return bytesSkipped;
    }

    protected abstract byte[] nextBuffer() throws IOException;

    private boolean isAvailable() throws IOException {
        if (this._isClosed) {
            throw new IOException("stream is closed");
        }
        if (this._buf == null || this._off >= this._buf.length) {
            this._buf = this.nextBuffer();
            this._off = 0;
        }
        return this._buf != null;
    }
}

