/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.html;

import net.sf.kdgcommons.html.HtmlUtil;
import net.sf.kdgcommons.lang.StringBuilderUtil;
import net.sf.kdgcommons.lang.StringUtil;

public final class URLBuilder {
    private StringBuilder _path = new StringBuilder(256);
    private StringBuilder _query = new StringBuilder(128);

    public URLBuilder() {
        this._path.append("/");
    }

    public URLBuilder(String path) {
        if (StringUtil.isBlank(path)) {
            path = "/";
        }
        this._path.append(path);
    }

    public URLBuilder(String protocol, String host, String path) {
        if (StringUtil.isBlank(path)) {
            path = "/";
        }
        if (host != null) {
            this._path.append(protocol == null ? "http" : protocol.toLowerCase()).append("://").append(host);
        }
        this._path.append(path.startsWith("/") ? "" : "/").append(path);
    }

    public URLBuilder appendPath(String pathElement) {
        if (StringBuilderUtil.lastChar(this._path) != '/') {
            this._path.append("/");
        }
        this._path.append(HtmlUtil.urlEncode(pathElement));
        return this;
    }

    public URLBuilder appendParameter(String name, String value) {
        if (this._query.length() > 0) {
            this._query.append("&");
        }
        this._query.append(HtmlUtil.urlEncode(name)).append("=").append(HtmlUtil.urlEncode(value));
        return this;
    }

    public URLBuilder appendOptionalParameter(String name, String value) {
        return value != null ? this.appendParameter(name, value) : this;
    }

    public String toString() {
        return this._query.length() > 0 ? this._path.toString() + "?" + this._query.toString() : this._path.toString();
    }
}

