/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.collections;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMap<K, V>
implements Map<K, V> {
    private Map<K, V> _delegate;
    private ValueFactory<V> _valueFactory;
    private boolean _updateMap;

    public DefaultMap(Map<K, V> delegate, ValueFactory<V> factory, boolean update) {
        this._delegate = delegate;
        this._valueFactory = factory;
        this._updateMap = update;
    }

    public DefaultMap(Map<K, V> delegate, V value) {
        this(delegate, new StaticValueFactory<V>(value), false);
    }

    public DefaultMap(Map<K, V> delegate, ValueFactory<V> factory) {
        this(delegate, factory, true);
    }

    @Override
    public V get(Object key) {
        if (this._delegate.containsKey(key)) {
            return this._delegate.get(key);
        }
        V value = this._valueFactory.newInstance();
        if (this._updateMap) {
            this._delegate.put(key, value);
        }
        return value;
    }

    @Override
    public int size() {
        return this._delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this._delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this._delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._delegate.containsValue(value);
    }

    @Override
    public V put(K key, V value) {
        return this._delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this._delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m2) {
        this._delegate.putAll(m2);
    }

    @Override
    public void clear() {
        this._delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return this._delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this._delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._delegate.entrySet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticValueFactory<T>
    implements ValueFactory<T> {
        private T _value;

        public StaticValueFactory(T value) {
            this._value = value;
        }

        @Override
        public T newInstance() {
            return this._value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueFactory<T> {
        public T newInstance();
    }
}

