/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.collections;

import java.util.Arrays;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompoundKey
implements Iterable<Object> {
    private Object[] _components;
    private int _hashCode;
    private String _stringValue;

    public CompoundKey(Object ... components) {
        this._components = components;
        for (Object component : components) {
            if (component == null) continue;
            this._hashCode = this._hashCode * 37 + component.hashCode();
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this._components).iterator();
    }

    public String toString() {
        if (this._stringValue == null) {
            StringBuilder buf = new StringBuilder(this._components.length * 16);
            buf.append("[");
            for (Object comp : this._components) {
                if (buf.length() > 1) {
                    buf.append(",");
                }
                buf.append(comp);
            }
            buf.append("]");
            this._stringValue = buf.toString();
        }
        return this._stringValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CompoundKey) {
            return Arrays.equals(this._components, ((CompoundKey)obj)._components);
        }
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }
}

