/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtil {
    public static <T> Set<T> asSet(T ... elems) {
        HashSet<T> result = new HashSet<T>();
        for (T elem : elems) {
            result.add(elem);
        }
        return result;
    }

    public static <T> void addAll(Collection<T> coll, T ... elems) {
        for (T elem : elems) {
            coll.add(elem);
        }
    }

    public static <T> void addAll(Collection<T> coll, Iterator<T> src) {
        while (src.hasNext()) {
            coll.add(src.next());
        }
    }

    public static <T> void addAll(Collection<T> coll, Iterable<T> src) {
        CollectionUtil.addAll(coll, src.iterator());
    }

    public static <T> List<T> cast(List<?> list, Class<T> klass) {
        for (Object obj : list) {
            klass.cast(obj);
        }
        return list;
    }

    public static <T> Set<T> cast(Set<?> set, Class<T> klass) {
        for (Object obj : set) {
            klass.cast(obj);
        }
        return set;
    }

    public static <T> List<T> resize(List<T> list, int newSize, T obj) {
        block7: {
            block6: {
                if (list instanceof ArrayList) {
                    ((ArrayList)list).ensureCapacity(newSize);
                }
                if (list.size() >= newSize) break block6;
                for (int ii2 = list.size(); ii2 < newSize; ++ii2) {
                    list.add(obj);
                }
                break block7;
            }
            if (list.size() <= newSize) break block7;
            if (list instanceof RandomAccess) {
                for (int ii3 = list.size() - 1; ii3 >= newSize; --ii3) {
                    list.remove(ii3);
                }
            } else {
                ListIterator<T> itx = list.listIterator(newSize);
                while (itx.hasNext()) {
                    itx.next();
                    itx.remove();
                }
            }
        }
        return list;
    }

    public static <T> List<T> resize(List<T> list, int newSize) {
        return CollectionUtil.resize(list, newSize, null);
    }

    public static <T> String join(Iterable<T> coll, String delim) {
        if (coll == null) {
            return "";
        }
        boolean isFirst = true;
        StringBuilder buf = new StringBuilder(1024);
        for (T item : coll) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(delim);
            }
            if (item == null) continue;
            buf.append(String.valueOf(item));
        }
        return buf.toString();
    }

    public static <T> List<T> filter(List<T> list, String regex, boolean include) {
        Pattern pattern = Pattern.compile(regex);
        ArrayList<T> result = new ArrayList<T>(list.size());
        for (T obj : list) {
            String str = obj == null ? "" : obj.toString();
            if (pattern.matcher(str).matches() != include) continue;
            result.add(obj);
        }
        return result;
    }
}

