/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.kdgcommons.buffer.BufferFacade;
import net.sf.kdgcommons.io.IOUtil;

public class MappedFileBuffer
implements BufferFacade,
Cloneable {
    private static final int MAX_SEGMENT_SIZE = 0x8000000;
    private File _file;
    private boolean _isWritable;
    private long _segmentSize;
    private MappedByteBuffer[] _buffers;

    public MappedFileBuffer(File file) throws IOException {
        this(file, 0x8000000, false);
    }

    public MappedFileBuffer(File file, boolean readWrite) throws IOException {
        this(file, 0x8000000, readWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedFileBuffer(File file, int segmentSize, boolean readWrite) throws IOException {
        if (segmentSize > 0x8000000) {
            throw new IllegalArgumentException("segment size too large (max is 134217728): " + segmentSize);
        }
        this._file = file;
        this._isWritable = readWrite;
        this._segmentSize = segmentSize;
        RandomAccessFile mappedFile = null;
        try {
            String mode = readWrite ? "rw" : "r";
            FileChannel.MapMode mapMode = readWrite ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY;
            mappedFile = new RandomAccessFile(file, mode);
            FileChannel channel = mappedFile.getChannel();
            long fileSize = file.length();
            int bufArraySize = (int)(fileSize / (long)segmentSize) + (fileSize % (long)segmentSize != 0L ? 1 : 0);
            this._buffers = new MappedByteBuffer[bufArraySize];
            int bufIdx = 0;
            for (long offset = 0L; offset < fileSize; offset += (long)segmentSize) {
                long remainingFileSize = fileSize - offset;
                long thisSegmentSize = Math.min(2L * (long)segmentSize, remainingFileSize);
                this._buffers[bufIdx++] = channel.map(mapMode, offset, thisSegmentSize);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(mappedFile);
            throw throwable;
        }
        IOUtil.closeQuietly(mappedFile);
    }

    public long capacity() {
        return this._file.length();
    }

    public long limit() {
        return this.capacity();
    }

    public File file() {
        return this._file;
    }

    public boolean isWritable() {
        return this._isWritable;
    }

    public ByteOrder getByteOrder() {
        return this._buffers[0].order();
    }

    public void setByteOrder(ByteOrder order) {
        for (MappedByteBuffer child : this._buffers) {
            child.order(order);
        }
    }

    public byte get(long index) {
        return this.buffer(index).get();
    }

    public void put(long index, byte value) {
        this.buffer(index).put(value);
    }

    public int getInt(long index) {
        return this.buffer(index).getInt();
    }

    public void putInt(long index, int value) {
        this.buffer(index).putInt(value);
    }

    public long getLong(long index) {
        return this.buffer(index).getLong();
    }

    public void putLong(long index, long value) {
        this.buffer(index).putLong(value);
    }

    public short getShort(long index) {
        return this.buffer(index).getShort();
    }

    public void putShort(long index, short value) {
        this.buffer(index).putShort(value);
    }

    public float getFloat(long index) {
        return this.buffer(index).getFloat();
    }

    public void putFloat(long index, float value) {
        this.buffer(index).putFloat(value);
    }

    public double getDouble(long index) {
        return this.buffer(index).getDouble();
    }

    public void putDouble(long index, double value) {
        this.buffer(index).putDouble(value);
    }

    public char getChar(long index) {
        return this.buffer(index).getChar();
    }

    public void putChar(long index, char value) {
        this.buffer(index).putChar(value);
    }

    public byte[] getBytes(long index, int len) {
        byte[] ret = new byte[len];
        return this.getBytes(index, ret, 0, len);
    }

    public byte[] getBytes(long index, byte[] array, int off, int len) {
        while (len > 0) {
            ByteBuffer buf = this.buffer(index);
            int count = Math.min(len, buf.remaining());
            buf.get(array, off, count);
            index += (long)count;
            off += count;
            len -= count;
        }
        return array;
    }

    public void putBytes(long index, byte[] value) {
        this.putBytes(index, value, 0, value.length);
    }

    public void putBytes(long index, byte[] value, int off, int len) {
        while (len > 0) {
            ByteBuffer buf = this.buffer(index);
            int count = Math.min(len, buf.remaining());
            buf.put(value, off, count);
            index += (long)count;
            off += count;
            len -= count;
        }
    }

    public ByteBuffer slice(long index) {
        return this.buffer(index).slice();
    }

    public void force() {
        for (MappedByteBuffer buf : this._buffers) {
            buf.force();
        }
    }

    public MappedFileBuffer clone() {
        try {
            MappedFileBuffer that = (MappedFileBuffer)super.clone();
            that._buffers = new MappedByteBuffer[this._buffers.length];
            for (int ii2 = 0; ii2 < this._buffers.length; ++ii2) {
                if (this._buffers[ii2] == null) continue;
                that._buffers[ii2] = (MappedByteBuffer)this._buffers[ii2].duplicate();
            }
            return that;
        }
        catch (CloneNotSupportedException ex2) {
            throw new RuntimeException("unreachable code", ex2);
        }
    }

    protected ByteBuffer buffer(long index) {
        MappedByteBuffer buf = this._buffers[(int)(index / this._segmentSize)];
        ((ByteBuffer)buf).position((int)(index % this._segmentSize));
        return buf;
    }
}

