/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.buffer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer _buf;
    private boolean _isClosed;

    public ByteBufferOutputStream(ByteBuffer buf) {
        this(buf, 0);
    }

    public ByteBufferOutputStream(ByteBuffer buf, int index) {
        this._buf = buf;
        this._buf.position(index);
    }

    public void close() throws IOException {
        this._isClosed = true;
    }

    public void flush() throws IOException {
        if (this._buf instanceof MappedByteBuffer) {
            ((MappedByteBuffer)this._buf).force();
        }
    }

    public void write(byte[] b2, int off, int len) throws IOException {
        if (this._isClosed) {
            throw new IOException("buffer is closed");
        }
        if (len > this._buf.remaining()) {
            throw new IOException("write too large: " + len + " bytes, " + this._buf.remaining() + " remaining in buffer");
        }
        this._buf.put(b2, off, len);
    }

    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    public void write(int b2) throws IOException {
        if (this._isClosed) {
            throw new IOException("buffer is closed");
        }
        if (this._buf.remaining() == 0) {
            throw new IOException("no space left in buffer");
        }
        this._buf.put((byte)b2);
    }
}

