/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.buffer;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.sf.kdgcommons.io.IOUtil;
import net.sf.kdgcommons.lang.StringUtil;

public class BufferUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MappedByteBuffer map(File file, long offset, long length, FileChannel.MapMode mode) throws IOException {
        String rafMode = mode.equals(FileChannel.MapMode.READ_ONLY) ? "r" : "rw";
        RandomAccessFile raf = new RandomAccessFile(file, rafMode);
        try {
            MappedByteBuffer mappedByteBuffer = raf.getChannel().map(mode, offset, length);
            return mappedByteBuffer;
        }
        finally {
            IOUtil.closeQuietly(raf);
        }
    }

    public static String getUTF8String(ByteBuffer buf, int off, int len) {
        byte[] bytes = new byte[len];
        buf.position(off);
        buf.get(bytes, 0, len);
        return StringUtil.fromUTF8(bytes);
    }

    public static char[] getChars(ByteBuffer buf, int off, int count) {
        char[] chars = new char[count];
        buf.position(off);
        for (int ii2 = 0; ii2 < count; ++ii2) {
            chars[ii2] = buf.getChar();
        }
        return chars;
    }
}

