/*
 * Decompiled with CFR 0.152.
 */
package net.sf.kdgcommons.buffer;

import java.nio.ByteBuffer;
import net.sf.kdgcommons.buffer.BufferFacade;
import net.sf.kdgcommons.buffer.ByteBufferThreadLocal;
import net.sf.kdgcommons.buffer.MappedFileBuffer;
import net.sf.kdgcommons.buffer.MappedFileBufferThreadLocal;

public class BufferFacadeFactory {
    public static BufferFacade create(ByteBuffer buf) {
        return new ByteBufferFacade(buf);
    }

    public static BufferFacade create(ByteBuffer buf, long base) {
        return new ByteBufferFacade(buf, (int)base);
    }

    public static BufferFacade createThreadsafe(ByteBuffer buf) {
        return new ByteBufferTLFacade(buf);
    }

    public static BufferFacade createThreadsafe(ByteBuffer buf, long base) {
        return new ByteBufferTLFacade(buf, (int)base);
    }

    public static BufferFacade create(MappedFileBuffer buf) {
        return buf;
    }

    public static BufferFacade create(MappedFileBuffer buf, long base) {
        return new MappedFileBufferFacade(buf, base);
    }

    public static BufferFacade createThreadsafe(MappedFileBuffer buf) {
        return new MappedFileBufferTLFacade(buf);
    }

    public static BufferFacade createThreadsafe(MappedFileBuffer buf, long base) {
        return new MappedFileBufferTLFacade(buf, (int)base);
    }

    public static class MappedFileBufferTLFacade
    implements BufferFacade {
        private MappedFileBufferThreadLocal _tl;
        private long _base;

        public MappedFileBufferTLFacade(MappedFileBuffer buf) {
            this._tl = new MappedFileBufferThreadLocal(buf);
        }

        public MappedFileBufferTLFacade(MappedFileBuffer buf, long base) {
            this(buf);
            this._base = base;
        }

        public byte get(long index) {
            return ((MappedFileBuffer)this._tl.get()).get(index + this._base);
        }

        public void put(long index, byte value) {
            ((MappedFileBuffer)this._tl.get()).put(index + this._base, value);
        }

        public short getShort(long index) {
            return ((MappedFileBuffer)this._tl.get()).getShort(index + this._base);
        }

        public void putShort(long index, short value) {
            ((MappedFileBuffer)this._tl.get()).putShort(index + this._base, value);
        }

        public int getInt(long index) {
            return ((MappedFileBuffer)this._tl.get()).getInt(index + this._base);
        }

        public void putInt(long index, int value) {
            ((MappedFileBuffer)this._tl.get()).putInt(index + this._base, value);
        }

        public long getLong(long index) {
            return ((MappedFileBuffer)this._tl.get()).getLong(index + this._base);
        }

        public void putLong(long index, long value) {
            ((MappedFileBuffer)this._tl.get()).putLong(index + this._base, value);
        }

        public float getFloat(long index) {
            return ((MappedFileBuffer)this._tl.get()).getFloat(index + this._base);
        }

        public void putFloat(long index, float value) {
            ((MappedFileBuffer)this._tl.get()).putFloat(index + this._base, value);
        }

        public double getDouble(long index) {
            return ((MappedFileBuffer)this._tl.get()).getDouble(index + this._base);
        }

        public void putDouble(long index, double value) {
            ((MappedFileBuffer)this._tl.get()).putDouble(index + this._base, value);
        }

        public char getChar(long index) {
            return ((MappedFileBuffer)this._tl.get()).getChar(index + this._base);
        }

        public void putChar(long index, char value) {
            ((MappedFileBuffer)this._tl.get()).putChar(index + this._base, value);
        }

        public byte[] getBytes(long index, int len) {
            return ((MappedFileBuffer)this._tl.get()).getBytes(index + this._base, len);
        }

        public void putBytes(long index, byte[] value) {
            ((MappedFileBuffer)this._tl.get()).putBytes(index + this._base, value);
        }

        public ByteBuffer slice(long index) {
            return ((MappedFileBuffer)this._tl.get()).slice(index + this._base);
        }

        public long capacity() {
            return ((MappedFileBuffer)this._tl.get()).capacity() - this._base;
        }

        public long limit() {
            return ((MappedFileBuffer)this._tl.get()).limit() - this._base;
        }
    }

    private static class MappedFileBufferFacade
    implements BufferFacade {
        private MappedFileBuffer _buf;
        private long _base;

        public MappedFileBufferFacade(MappedFileBuffer buf) {
            this._buf = buf;
        }

        public MappedFileBufferFacade(MappedFileBuffer buf, long base) {
            this(buf);
            this._base = base;
        }

        public byte get(long index) {
            return this._buf.get(index + this._base);
        }

        public void put(long index, byte value) {
            this._buf.put(index + this._base, value);
        }

        public short getShort(long index) {
            return this._buf.getShort(index + this._base);
        }

        public void putShort(long index, short value) {
            this._buf.putShort(index + this._base, value);
        }

        public int getInt(long index) {
            return this._buf.getInt(index + this._base);
        }

        public void putInt(long index, int value) {
            this._buf.putInt(index + this._base, value);
        }

        public long getLong(long index) {
            return this._buf.getLong(index + this._base);
        }

        public void putLong(long index, long value) {
            this._buf.putLong(index + this._base, value);
        }

        public float getFloat(long index) {
            return this._buf.getFloat(index + this._base);
        }

        public void putFloat(long index, float value) {
            this._buf.putFloat(index + this._base, value);
        }

        public double getDouble(long index) {
            return this._buf.getDouble(index + this._base);
        }

        public void putDouble(long index, double value) {
            this._buf.putDouble(index + this._base, value);
        }

        public char getChar(long index) {
            return this._buf.getChar(index + this._base);
        }

        public void putChar(long index, char value) {
            this._buf.putChar(index + this._base, value);
        }

        public byte[] getBytes(long index, int len) {
            return this._buf.getBytes(index + this._base, len);
        }

        public void putBytes(long index, byte[] value) {
            this._buf.putBytes(index + this._base, value);
        }

        public ByteBuffer slice(long index) {
            return this._buf.slice(index + this._base);
        }

        public long capacity() {
            return this._buf.capacity() - this._base;
        }

        public long limit() {
            return this._buf.limit() - this._base;
        }
    }

    public static class ByteBufferTLFacade
    implements BufferFacade {
        private ByteBufferThreadLocal _tl;
        private int _base;

        public ByteBufferTLFacade(ByteBuffer buf) {
            this._tl = new ByteBufferThreadLocal(buf);
        }

        public ByteBufferTLFacade(ByteBuffer buf, int base) {
            this(buf);
            this._base = base;
        }

        public byte get(long index) {
            return ((ByteBuffer)this._tl.get()).get((int)index + this._base);
        }

        public void put(long index, byte value) {
            ((ByteBuffer)this._tl.get()).put((int)index + this._base, value);
        }

        public short getShort(long index) {
            return ((ByteBuffer)this._tl.get()).getShort((int)index + this._base);
        }

        public void putShort(long index, short value) {
            ((ByteBuffer)this._tl.get()).putShort((int)index + this._base, value);
        }

        public int getInt(long index) {
            return ((ByteBuffer)this._tl.get()).getInt((int)index + this._base);
        }

        public void putInt(long index, int value) {
            ((ByteBuffer)this._tl.get()).putInt((int)index + this._base, value);
        }

        public long getLong(long index) {
            return ((ByteBuffer)this._tl.get()).getLong((int)index + this._base);
        }

        public void putLong(long index, long value) {
            ((ByteBuffer)this._tl.get()).putLong((int)index + this._base, value);
        }

        public float getFloat(long index) {
            return ((ByteBuffer)this._tl.get()).getFloat((int)index + this._base);
        }

        public void putFloat(long index, float value) {
            ((ByteBuffer)this._tl.get()).putFloat((int)index + this._base, value);
        }

        public double getDouble(long index) {
            return ((ByteBuffer)this._tl.get()).getDouble((int)index + this._base);
        }

        public void putDouble(long index, double value) {
            ((ByteBuffer)this._tl.get()).putDouble((int)index + this._base, value);
        }

        public char getChar(long index) {
            return ((ByteBuffer)this._tl.get()).getChar((int)index + this._base);
        }

        public void putChar(long index, char value) {
            ((ByteBuffer)this._tl.get()).putChar((int)index + this._base, value);
        }

        public byte[] getBytes(long index, int len) {
            ByteBuffer buf = (ByteBuffer)this._tl.get();
            buf.position((int)index + this._base);
            byte[] ret = new byte[len];
            buf.get(ret);
            return ret;
        }

        public void putBytes(long index, byte[] value) {
            ByteBuffer buf = (ByteBuffer)this._tl.get();
            buf.position((int)index + this._base);
            buf.put(value);
        }

        public ByteBuffer slice(long index) {
            ByteBuffer buf = (ByteBuffer)this._tl.get();
            buf.position((int)index + this._base);
            return buf.slice();
        }

        public long capacity() {
            return ((ByteBuffer)this._tl.get()).capacity() - this._base;
        }

        public long limit() {
            return ((ByteBuffer)this._tl.get()).limit() - this._base;
        }
    }

    public static class ByteBufferFacade
    implements BufferFacade {
        private ByteBuffer _buf;
        private int _base;

        public ByteBufferFacade(ByteBuffer buf) {
            this._buf = buf;
        }

        public ByteBufferFacade(ByteBuffer buf, int base) {
            this(buf);
            this._base = base;
        }

        public byte get(long index) {
            return this._buf.get((int)index + this._base);
        }

        public void put(long index, byte value) {
            this._buf.put((int)index + this._base, value);
        }

        public short getShort(long index) {
            return this._buf.getShort((int)index + this._base);
        }

        public void putShort(long index, short value) {
            this._buf.putShort((int)index + this._base, value);
        }

        public int getInt(long index) {
            return this._buf.getInt((int)index + this._base);
        }

        public void putInt(long index, int value) {
            this._buf.putInt((int)index + this._base, value);
        }

        public long getLong(long index) {
            return this._buf.getLong((int)index + this._base);
        }

        public void putLong(long index, long value) {
            this._buf.putLong((int)index + this._base, value);
        }

        public float getFloat(long index) {
            return this._buf.getFloat((int)index + this._base);
        }

        public void putFloat(long index, float value) {
            this._buf.putFloat((int)index + this._base, value);
        }

        public double getDouble(long index) {
            return this._buf.getDouble((int)index + this._base);
        }

        public void putDouble(long index, double value) {
            this._buf.putDouble((int)index + this._base, value);
        }

        public char getChar(long index) {
            return this._buf.getChar((int)index + this._base);
        }

        public void putChar(long index, char value) {
            this._buf.putChar((int)index + this._base, value);
        }

        public byte[] getBytes(long index, int len) {
            this._buf.position((int)index + this._base);
            byte[] ret = new byte[len];
            this._buf.get(ret);
            return ret;
        }

        public void putBytes(long index, byte[] value) {
            this._buf.position((int)index + this._base);
            this._buf.put(value);
        }

        public ByteBuffer slice(long index) {
            this._buf.position((int)index + this._base);
            return this._buf.slice();
        }

        public long capacity() {
            return this._buf.capacity() - this._base;
        }

        public long limit() {
            return this._buf.limit() - this._base;
        }
    }
}

